/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD.
    define(['expect.js', '../../src/index'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    factory(require('expect.js'), require('../../src/index'));
  } else {
    // Browser globals (root is window)
    factory(root.expect, root.AdvantEdgeSandboxControllerRestApi);
  }
}(this, function(expect, AdvantEdgeSandboxControllerRestApi) {
  'use strict';

  var instance;

  beforeEach(function() {
    instance = new AdvantEdgeSandboxControllerRestApi.EventReplayApi();
  });

  describe('(package)', function() {
    describe('EventReplayApi', function() {
      describe('createReplayFile', function() {
        it('should call createReplayFile successfully', function(done) {
          // TODO: uncomment, update parameter values for createReplayFile call
          /*
          var name = "name_example";
          var replayFile = new AdvantEdgeSandboxControllerRestApi.Replay();
          replayFile.description = "";
          replayFile.events = [new AdvantEdgeSandboxControllerRestApi.ReplayEvent()];
          replayFile.events[0].time = 0;
          replayFile.events[0].event = new AdvantEdgeSandboxControllerRestApi.Event();
          replayFile.events[0].event.name = "";
          replayFile.events[0].event.type = "MOBILITY";
          replayFile.events[0].event.eventMobility = new AdvantEdgeSandboxControllerRestApi.EventMobility();
          replayFile.events[0].event.eventMobility.elementName = "";
          replayFile.events[0].event.eventMobility.dest = "";
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate = new AdvantEdgeSandboxControllerRestApi.EventNetworkCharacteristicsUpdate();
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.elementName = "";
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.elementType = "SCENARIO";
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar = new AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics();
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.latency = 0;
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.latencyVariation = 0;
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.latencyDistribution = "Normal";
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.throughput = 0;
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.throughputDl = 0;
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.throughputUl = 0;
          replayFile.events[0].event.eventNetworkCharacteristicsUpdate.netChar.packetLoss = 0.0;
          replayFile.events[0].event.eventPoasInRange = new AdvantEdgeSandboxControllerRestApi.EventPoasInRange();
          replayFile.events[0].event.eventPoasInRange.ue = "";
          replayFile.events[0].event.eventPoasInRange.poasInRange = [""];
          replayFile.events[0].event.eventScenarioUpdate = new AdvantEdgeSandboxControllerRestApi.EventScenarioUpdate();
          replayFile.events[0].event.eventScenarioUpdate.action = "ADD";
          replayFile.events[0].event.eventScenarioUpdate.node = new AdvantEdgeSandboxControllerRestApi.ScenarioNode();
          replayFile.events[0].event.eventScenarioUpdate.node.type = "UE";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion = new AdvantEdgeSandboxControllerRestApi.NodeDataUnion();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation = new AdvantEdgeSandboxControllerRestApi.PhysicalLocation();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.id = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.type = "UE";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.isExternal = false;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData = new AdvantEdgeSandboxControllerRestApi.GeoData();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location = new AdvantEdgeSandboxControllerRestApi.Point();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location.type = "Point";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location.coordinates = [];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.radius = ;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path = new AdvantEdgeSandboxControllerRestApi.LineString();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path.type = "LineString";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path.coordinates = [[]];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.eopMode = "LOOP";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.velocity = ;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.networkLocationsInRange = [""];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.connected = false;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.wireless = false;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.wirelessType = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork = new AdvantEdgeSandboxControllerRestApi.DNConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.dnn = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.ladn = false;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.ecsp = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.meta = {key: ""};
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.userMeta = {key: ""};
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes = [new AdvantEdgeSandboxControllerRestApi.Process()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].id = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].type = "UE-APP";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].isExternal = false;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].image = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].environment = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].commandArguments = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].commandExe = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig = new AdvantEdgeSandboxControllerRestApi.ServiceConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig.name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig.meSvcName = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig.ports = [new AdvantEdgeSandboxControllerRestApi.ServicePort()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig.ports[0].protocol = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig.ports[0].port = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].serviceConfig.ports[0].externalPort = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].gpuConfig = new AdvantEdgeSandboxControllerRestApi.GpuConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].gpuConfig.type = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].gpuConfig.count = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].memoryConfig = new AdvantEdgeSandboxControllerRestApi.MemoryConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].memoryConfig.min = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].memoryConfig.max = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].cpuConfig = new AdvantEdgeSandboxControllerRestApi.CpuConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].cpuConfig.min = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].cpuConfig.max = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig = new AdvantEdgeSandboxControllerRestApi.ExternalConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.ingressServiceMap = [new AdvantEdgeSandboxControllerRestApi.IngressService()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.ingressServiceMap[0].name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.ingressServiceMap[0].port = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.ingressServiceMap[0].externalPort = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.ingressServiceMap[0].protocol = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.egressServiceMap = [new AdvantEdgeSandboxControllerRestApi.EgressService()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.egressServiceMap[0].name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.egressServiceMap[0].meSvcName = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.egressServiceMap[0].ip = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.egressServiceMap[0].port = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].externalConfig.egressServiceMap[0].protocol = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].status = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].userChartLocation = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].userChartAlternateValues = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].userChartGroup = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].meta = {key: ""};
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].userMeta = {key: ""};
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar = new AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.latency = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.latencyVariation = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.latencyDistribution = "Normal";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.throughput = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.throughputDl = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.throughputUl = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].netChar.packetLoss = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].appLatency = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].appLatencyVariation = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].appThroughput = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].appPacketLoss = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes[0].placementId = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar = new AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latency = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latencyVariation = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latencyDistribution = "Normal";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughput = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughputDl = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughputUl = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.packetLoss = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkLatency = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkLatencyVariation = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkThroughput = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkPacketLoss = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.macId = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process = new AdvantEdgeSandboxControllerRestApi.Process();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.id = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.type = "UE-APP";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.isExternal = false;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.image = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.environment = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.commandArguments = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.commandExe = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig = new AdvantEdgeSandboxControllerRestApi.ServiceConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.meSvcName = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.ports = [new AdvantEdgeSandboxControllerRestApi.ServicePort()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.ports[0].protocol = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.ports[0].port = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.ports[0].externalPort = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig = new AdvantEdgeSandboxControllerRestApi.GpuConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig.type = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig.count = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig = new AdvantEdgeSandboxControllerRestApi.MemoryConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig.min = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig.max = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig = new AdvantEdgeSandboxControllerRestApi.CpuConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig.min = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig.max = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig = new AdvantEdgeSandboxControllerRestApi.ExternalConfig();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.ingressServiceMap = [new AdvantEdgeSandboxControllerRestApi.IngressService()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.ingressServiceMap[0].name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.ingressServiceMap[0].port = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.ingressServiceMap[0].externalPort = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.ingressServiceMap[0].protocol = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap = [new AdvantEdgeSandboxControllerRestApi.EgressService()];
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap[0].name = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap[0].meSvcName = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap[0].ip = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap[0].port = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap[0].protocol = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.status = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.userChartLocation = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.userChartAlternateValues = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.userChartGroup = "";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.meta = {key: ""};
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.userMeta = {key: ""};
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar = new AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics();
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latency = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latencyVariation = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latencyDistribution = "Normal";
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughput = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughputDl = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughputUl = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.packetLoss = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.appLatency = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.appLatencyVariation = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.appThroughput = 0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.appPacketLoss = 0.0;
          replayFile.events[0].event.eventScenarioUpdate.node.nodeDataUnion.process.placementId = "";
          replayFile.events[0].event.eventScenarioUpdate.node.parent = "";
          replayFile.events[0].event.eventScenarioUpdate.node.children = [""];
          replayFile.events[0].event.eventPduSession = new AdvantEdgeSandboxControllerRestApi.EventPduSession();
          replayFile.events[0].event.eventPduSession.action = "ADD";
          replayFile.events[0].event.eventPduSession.pduSession = new AdvantEdgeSandboxControllerRestApi.PDUSession();
          replayFile.events[0].event.eventPduSession.pduSession.ue = "";
          replayFile.events[0].event.eventPduSession.pduSession.id = "";
          replayFile.events[0].event.eventPduSession.pduSession.info = new AdvantEdgeSandboxControllerRestApi.PDUSessionInfo();
          replayFile.events[0].event.eventPduSession.pduSession.info.dnn = "";

          instance.createReplayFile(name, replayFile, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('createReplayFileFromScenarioExec', function() {
        it('should call createReplayFileFromScenarioExec successfully', function(done) {
          // TODO: uncomment, update parameter values for createReplayFileFromScenarioExec call
          /*
          var name = "name_example";
          var replayInfo = new AdvantEdgeSandboxControllerRestApi.ReplayInfo();
          replayInfo.scenarioName = "";
          replayInfo.description = "";

          instance.createReplayFileFromScenarioExec(name, replayInfo, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('deleteReplayFile', function() {
        it('should call deleteReplayFile successfully', function(done) {
          // TODO: uncomment, update parameter values for deleteReplayFile call
          /*
          var name = "name_example";

          instance.deleteReplayFile(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('deleteReplayFileList', function() {
        it('should call deleteReplayFileList successfully', function(done) {
          // TODO: uncomment deleteReplayFileList call
          /*

          instance.deleteReplayFileList(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getReplayFile', function() {
        it('should call getReplayFile successfully', function(done) {
          // TODO: uncomment, update parameter values for getReplayFile call and complete the assertions
          /*
          var name = "name_example";

          instance.getReplayFile(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.Replay);
            expect(data.description).to.be.a('string');
            expect(data.description).to.be("");
            {
              let dataCtr = data.events;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.ReplayEvent);
                expect(data.index).to.be.a('number');
                expect(data.index).to.be(0);
                expect(data.time).to.be.a('number');
                expect(data.time).to.be(0);
                expect(data.event).to.be.a(AdvantEdgeSandboxControllerRestApi.Event);
                      expect(data.event.name).to.be.a('string');
                  expect(data.event.name).to.be("");
                  expect(data.event.type).to.be.a('string');
                  expect(data.event.type).to.be("MOBILITY");
                  expect(data.event.eventMobility).to.be.a(AdvantEdgeSandboxControllerRestApi.EventMobility);
                        expect(data.event.eventMobility.elementName).to.be.a('string');
                    expect(data.event.eventMobility.elementName).to.be("");
                    expect(data.event.eventMobility.dest).to.be.a('string');
                    expect(data.event.eventMobility.dest).to.be("");
                  expect(data.event.eventNetworkCharacteristicsUpdate).to.be.a(AdvantEdgeSandboxControllerRestApi.EventNetworkCharacteristicsUpdate);
                        expect(data.event.eventNetworkCharacteristicsUpdate.elementName).to.be.a('string');
                    expect(data.event.eventNetworkCharacteristicsUpdate.elementName).to.be("");
                    expect(data.event.eventNetworkCharacteristicsUpdate.elementType).to.be.a('string');
                    expect(data.event.eventNetworkCharacteristicsUpdate.elementType).to.be("SCENARIO");
                    expect(data.event.eventNetworkCharacteristicsUpdate.netChar).to.be.a(AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics);
                          expect(data.event.eventNetworkCharacteristicsUpdate.netChar.latency).to.be.a('number');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.latency).to.be(0);
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.latencyVariation).to.be.a('number');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.latencyVariation).to.be(0);
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.latencyDistribution).to.be.a('string');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.latencyDistribution).to.be("Normal");
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.throughput).to.be.a('number');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.throughput).to.be(0);
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.throughputDl).to.be.a('number');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.throughputDl).to.be(0);
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.throughputUl).to.be.a('number');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.throughputUl).to.be(0);
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.packetLoss).to.be.a('number');
                      expect(data.event.eventNetworkCharacteristicsUpdate.netChar.packetLoss).to.be(0.0);
                  expect(data.event.eventPoasInRange).to.be.a(AdvantEdgeSandboxControllerRestApi.EventPoasInRange);
                        expect(data.event.eventPoasInRange.ue).to.be.a('string');
                    expect(data.event.eventPoasInRange.ue).to.be("");
                    {
                      let dataCtr = data.event.eventPoasInRange.poasInRange;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a('string');
                        expect(data).to.be("");
                      }
                    }
                  expect(data.event.eventScenarioUpdate).to.be.a(AdvantEdgeSandboxControllerRestApi.EventScenarioUpdate);
                        expect(data.event.eventScenarioUpdate.action).to.be.a('string');
                    expect(data.event.eventScenarioUpdate.action).to.be("ADD");
                    expect(data.event.eventScenarioUpdate.node).to.be.a(AdvantEdgeSandboxControllerRestApi.ScenarioNode);
                          expect(data.event.eventScenarioUpdate.node.type).to.be.a('string');
                      expect(data.event.eventScenarioUpdate.node.type).to.be("UE");
                      expect(data.event.eventScenarioUpdate.node.nodeDataUnion).to.be.a(AdvantEdgeSandboxControllerRestApi.NodeDataUnion);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation).to.be.a(AdvantEdgeSandboxControllerRestApi.PhysicalLocation);
                              expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.id).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.id).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.name).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.name).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.type).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.type).to.be("UE");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.isExternal).to.be.a('boolean');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.isExternal).to.be(false);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData).to.be.a(AdvantEdgeSandboxControllerRestApi.GeoData);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location).to.be.a(AdvantEdgeSandboxControllerRestApi.Point);
                                  expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location.type).to.be.a('string');
                              expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location.type).to.be("Point");
                              {
                                let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.location.coordinates;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('number');
                                  expect(data).to.be();
                                }
                              }
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.radius).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.radius).to.be();
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path).to.be.a(AdvantEdgeSandboxControllerRestApi.LineString);
                                  expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path.type).to.be.a('string');
                              expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path.type).to.be("LineString");
                              {
                                let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.path.coordinates;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a(Array);
                                  expect(data).to.be([]);
                                }
                              }
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.eopMode).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.eopMode).to.be("LOOP");
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.velocity).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.geoData.velocity).to.be();
                          {
                            let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.networkLocationsInRange;
                            expect(dataCtr).to.be.an(Array);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.connected).to.be.a('boolean');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.connected).to.be(false);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.wireless).to.be.a('boolean');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.wireless).to.be(false);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.wirelessType).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.wirelessType).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork).to.be.a(AdvantEdgeSandboxControllerRestApi.DNConfig);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.dnn).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.dnn).to.be("");
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.ladn).to.be.a('boolean');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.ladn).to.be(false);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.ecsp).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.dataNetwork.ecsp).to.be("");
                          {
                            let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.meta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          {
                            let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.userMeta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          {
                            let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.processes;
                            expect(dataCtr).to.be.an(Array);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.Process);
                              expect(data.id).to.be.a('string');
                              expect(data.id).to.be("");
                              expect(data.name).to.be.a('string');
                              expect(data.name).to.be("");
                              expect(data.type).to.be.a('string');
                              expect(data.type).to.be("UE-APP");
                              expect(data.isExternal).to.be.a('boolean');
                              expect(data.isExternal).to.be(false);
                              expect(data.image).to.be.a('string');
                              expect(data.image).to.be("");
                              expect(data.environment).to.be.a('string');
                              expect(data.environment).to.be("");
                              expect(data.commandArguments).to.be.a('string');
                              expect(data.commandArguments).to.be("");
                              expect(data.commandExe).to.be.a('string');
                              expect(data.commandExe).to.be("");
                              expect(data.serviceConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.ServiceConfig);
                                    expect(data.serviceConfig.name).to.be.a('string');
                                expect(data.serviceConfig.name).to.be("");
                                expect(data.serviceConfig.meSvcName).to.be.a('string');
                                expect(data.serviceConfig.meSvcName).to.be("");
                                {
                                  let dataCtr = data.serviceConfig.ports;
                                  expect(dataCtr).to.be.an(Array);
                                  expect(dataCtr).to.not.be.empty();
                                  for (let p in dataCtr) {
                                    let data = dataCtr[p];
                                    expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.ServicePort);
                                    expect(data.protocol).to.be.a('string');
                                    expect(data.protocol).to.be("");
                                    expect(data.port).to.be.a('number');
                                    expect(data.port).to.be(0);
                                    expect(data.externalPort).to.be.a('number');
                                    expect(data.externalPort).to.be(0);
                                  }
                                }
                              expect(data.gpuConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.GpuConfig);
                                    expect(data.gpuConfig.type).to.be.a('string');
                                expect(data.gpuConfig.type).to.be("");
                                expect(data.gpuConfig.count).to.be.a('number');
                                expect(data.gpuConfig.count).to.be(0);
                              expect(data.memoryConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.MemoryConfig);
                                    expect(data.memoryConfig.min).to.be.a('number');
                                expect(data.memoryConfig.min).to.be(0);
                                expect(data.memoryConfig.max).to.be.a('number');
                                expect(data.memoryConfig.max).to.be(0);
                              expect(data.cpuConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.CpuConfig);
                                    expect(data.cpuConfig.min).to.be.a('number');
                                expect(data.cpuConfig.min).to.be(0.0);
                                expect(data.cpuConfig.max).to.be.a('number');
                                expect(data.cpuConfig.max).to.be(0.0);
                              expect(data.externalConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.ExternalConfig);
                                    {
                                  let dataCtr = data.externalConfig.ingressServiceMap;
                                  expect(dataCtr).to.be.an(Array);
                                  expect(dataCtr).to.not.be.empty();
                                  for (let p in dataCtr) {
                                    let data = dataCtr[p];
                                    expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.IngressService);
                                    expect(data.name).to.be.a('string');
                                    expect(data.name).to.be("");
                                    expect(data.port).to.be.a('number');
                                    expect(data.port).to.be(0);
                                    expect(data.externalPort).to.be.a('number');
                                    expect(data.externalPort).to.be(0);
                                    expect(data.protocol).to.be.a('string');
                                    expect(data.protocol).to.be("");
                                  }
                                }
                                {
                                  let dataCtr = data.externalConfig.egressServiceMap;
                                  expect(dataCtr).to.be.an(Array);
                                  expect(dataCtr).to.not.be.empty();
                                  for (let p in dataCtr) {
                                    let data = dataCtr[p];
                                    expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.EgressService);
                                    expect(data.name).to.be.a('string');
                                    expect(data.name).to.be("");
                                    expect(data.meSvcName).to.be.a('string');
                                    expect(data.meSvcName).to.be("");
                                    expect(data.ip).to.be.a('string');
                                    expect(data.ip).to.be("");
                                    expect(data.port).to.be.a('number');
                                    expect(data.port).to.be(0);
                                    expect(data.protocol).to.be.a('string');
                                    expect(data.protocol).to.be("");
                                  }
                                }
                              expect(data.status).to.be.a('string');
                              expect(data.status).to.be("");
                              expect(data.userChartLocation).to.be.a('string');
                              expect(data.userChartLocation).to.be("");
                              expect(data.userChartAlternateValues).to.be.a('string');
                              expect(data.userChartAlternateValues).to.be("");
                              expect(data.userChartGroup).to.be.a('string');
                              expect(data.userChartGroup).to.be("");
                              {
                                let dataCtr = data.meta;
                                expect(dataCtr).to.be.an(Object);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              {
                                let dataCtr = data.userMeta;
                                expect(dataCtr).to.be.an(Object);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              expect(data.netChar).to.be.a(AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics);
                                    expect(data.netChar.latency).to.be.a('number');
                                expect(data.netChar.latency).to.be(0);
                                expect(data.netChar.latencyVariation).to.be.a('number');
                                expect(data.netChar.latencyVariation).to.be(0);
                                expect(data.netChar.latencyDistribution).to.be.a('string');
                                expect(data.netChar.latencyDistribution).to.be("Normal");
                                expect(data.netChar.throughput).to.be.a('number');
                                expect(data.netChar.throughput).to.be(0);
                                expect(data.netChar.throughputDl).to.be.a('number');
                                expect(data.netChar.throughputDl).to.be(0);
                                expect(data.netChar.throughputUl).to.be.a('number');
                                expect(data.netChar.throughputUl).to.be(0);
                                expect(data.netChar.packetLoss).to.be.a('number');
                                expect(data.netChar.packetLoss).to.be(0.0);
                              expect(data.appLatency).to.be.a('number');
                              expect(data.appLatency).to.be(0);
                              expect(data.appLatencyVariation).to.be.a('number');
                              expect(data.appLatencyVariation).to.be(0);
                              expect(data.appThroughput).to.be.a('number');
                              expect(data.appThroughput).to.be(0);
                              expect(data.appPacketLoss).to.be.a('number');
                              expect(data.appPacketLoss).to.be(0.0);
                              expect(data.placementId).to.be.a('string');
                              expect(data.placementId).to.be("");
                            }
                          }
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar).to.be.a(AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latency).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latency).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latencyVariation).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latencyVariation).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latencyDistribution).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.latencyDistribution).to.be("Normal");
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughput).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughput).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughputDl).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughputDl).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughputUl).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.throughputUl).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.packetLoss).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.netChar.packetLoss).to.be(0.0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkLatency).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkLatency).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkLatencyVariation).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkLatencyVariation).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkThroughput).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkThroughput).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkPacketLoss).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.linkPacketLoss).to.be(0.0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.macId).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.physicalLocation.macId).to.be("");
                        expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process).to.be.a(AdvantEdgeSandboxControllerRestApi.Process);
                              expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.id).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.id).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.name).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.name).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.type).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.type).to.be("UE-APP");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.isExternal).to.be.a('boolean');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.isExternal).to.be(false);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.image).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.image).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.environment).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.environment).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.commandArguments).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.commandArguments).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.commandExe).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.commandExe).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.ServiceConfig);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.name).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.name).to.be("");
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.meSvcName).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.meSvcName).to.be("");
                            {
                              let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.process.serviceConfig.ports;
                              expect(dataCtr).to.be.an(Array);
                              expect(dataCtr).to.not.be.empty();
                              for (let p in dataCtr) {
                                let data = dataCtr[p];
                                expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.ServicePort);
                                expect(data.protocol).to.be.a('string');
                                expect(data.protocol).to.be("");
                                expect(data.port).to.be.a('number');
                                expect(data.port).to.be(0);
                                expect(data.externalPort).to.be.a('number');
                                expect(data.externalPort).to.be(0);
                              }
                            }
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.GpuConfig);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig.type).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig.type).to.be("");
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig.count).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.gpuConfig.count).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.MemoryConfig);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig.min).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig.min).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig.max).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.memoryConfig.max).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.CpuConfig);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig.min).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig.min).to.be(0.0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig.max).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.cpuConfig.max).to.be(0.0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig).to.be.a(AdvantEdgeSandboxControllerRestApi.ExternalConfig);
                                {
                              let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.ingressServiceMap;
                              expect(dataCtr).to.be.an(Array);
                              expect(dataCtr).to.not.be.empty();
                              for (let p in dataCtr) {
                                let data = dataCtr[p];
                                expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.IngressService);
                                expect(data.name).to.be.a('string');
                                expect(data.name).to.be("");
                                expect(data.port).to.be.a('number');
                                expect(data.port).to.be(0);
                                expect(data.externalPort).to.be.a('number');
                                expect(data.externalPort).to.be(0);
                                expect(data.protocol).to.be.a('string');
                                expect(data.protocol).to.be("");
                              }
                            }
                            {
                              let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.process.externalConfig.egressServiceMap;
                              expect(dataCtr).to.be.an(Array);
                              expect(dataCtr).to.not.be.empty();
                              for (let p in dataCtr) {
                                let data = dataCtr[p];
                                expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.EgressService);
                                expect(data.name).to.be.a('string');
                                expect(data.name).to.be("");
                                expect(data.meSvcName).to.be.a('string');
                                expect(data.meSvcName).to.be("");
                                expect(data.ip).to.be.a('string');
                                expect(data.ip).to.be("");
                                expect(data.port).to.be.a('number');
                                expect(data.port).to.be(0);
                                expect(data.protocol).to.be.a('string');
                                expect(data.protocol).to.be("");
                              }
                            }
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.status).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.status).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.userChartLocation).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.userChartLocation).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.userChartAlternateValues).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.userChartAlternateValues).to.be("");
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.userChartGroup).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.userChartGroup).to.be("");
                          {
                            let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.process.meta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          {
                            let dataCtr = data.event.eventScenarioUpdate.node.nodeDataUnion.process.userMeta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar).to.be.a(AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics);
                                expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latency).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latency).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latencyVariation).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latencyVariation).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latencyDistribution).to.be.a('string');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.latencyDistribution).to.be("Normal");
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughput).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughput).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughputDl).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughputDl).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughputUl).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.throughputUl).to.be(0);
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.packetLoss).to.be.a('number');
                            expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.netChar.packetLoss).to.be(0.0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appLatency).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appLatency).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appLatencyVariation).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appLatencyVariation).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appThroughput).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appThroughput).to.be(0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appPacketLoss).to.be.a('number');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.appPacketLoss).to.be(0.0);
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.placementId).to.be.a('string');
                          expect(data.event.eventScenarioUpdate.node.nodeDataUnion.process.placementId).to.be("");
                      expect(data.event.eventScenarioUpdate.node.parent).to.be.a('string');
                      expect(data.event.eventScenarioUpdate.node.parent).to.be("");
                      {
                        let dataCtr = data.event.eventScenarioUpdate.node.children;
                        expect(dataCtr).to.be.an(Array);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a('string');
                          expect(data).to.be("");
                        }
                      }
                  expect(data.event.eventPduSession).to.be.a(AdvantEdgeSandboxControllerRestApi.EventPduSession);
                        expect(data.event.eventPduSession.action).to.be.a('string');
                    expect(data.event.eventPduSession.action).to.be("ADD");
                    expect(data.event.eventPduSession.pduSession).to.be.a(AdvantEdgeSandboxControllerRestApi.PDUSession);
                          expect(data.event.eventPduSession.pduSession.ue).to.be.a('string');
                      expect(data.event.eventPduSession.pduSession.ue).to.be("");
                      expect(data.event.eventPduSession.pduSession.id).to.be.a('string');
                      expect(data.event.eventPduSession.pduSession.id).to.be("");
                      expect(data.event.eventPduSession.pduSession.info).to.be.a(AdvantEdgeSandboxControllerRestApi.PDUSessionInfo);
                            expect(data.event.eventPduSession.pduSession.info.dnn).to.be.a('string');
                        expect(data.event.eventPduSession.pduSession.info.dnn).to.be("");
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getReplayFileList', function() {
        it('should call getReplayFileList successfully', function(done) {
          // TODO: uncomment getReplayFileList call and complete the assertions
          /*

          instance.getReplayFileList(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.ReplayFileList);
            {
              let dataCtr = data.replayFiles;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a('string');
                expect(data).to.be("");
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getReplayStatus', function() {
        it('should call getReplayStatus successfully', function(done) {
          // TODO: uncomment getReplayStatus call and complete the assertions
          /*

          instance.getReplayStatus(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgeSandboxControllerRestApi.ReplayStatus);
            expect(data.replayFileRunning).to.be.a('string');
            expect(data.replayFileRunning).to.be("");
            expect(data.index).to.be.a('number');
            expect(data.index).to.be(0);
            expect(data.maxIndex).to.be.a('number');
            expect(data.maxIndex).to.be(0);
            expect(data.loopMode).to.be.a('boolean');
            expect(data.loopMode).to.be(false);
            expect(data.timeRemaining).to.be.a('number');
            expect(data.timeRemaining).to.be(0);
            expect(data.timeToNextEvent).to.be.a('number');
            expect(data.timeToNextEvent).to.be(0);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('loopReplay', function() {
        it('should call loopReplay successfully', function(done) {
          // TODO: uncomment, update parameter values for loopReplay call
          /*
          var name = "name_example";

          instance.loopReplay(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('playReplayFile', function() {
        it('should call playReplayFile successfully', function(done) {
          // TODO: uncomment, update parameter values for playReplayFile call
          /*
          var name = "name_example";

          instance.playReplayFile(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('stopReplayFile', function() {
        it('should call stopReplayFile successfully', function(done) {
          // TODO: uncomment, update parameter values for stopReplayFile call
          /*
          var name = "name_example";

          instance.stopReplayFile(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
    });
  });

}));
