/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Platform Controller REST API
 * This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ConnectivityConfig', 'model/Domain', 'model/NetworkCharacteristics'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ConnectivityConfig'), require('./Domain'), require('./NetworkCharacteristics'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgePlatformControllerRestApi) {
      root.AdvantEdgePlatformControllerRestApi = {};
    }
    root.AdvantEdgePlatformControllerRestApi.Deployment = factory(root.AdvantEdgePlatformControllerRestApi.ApiClient, root.AdvantEdgePlatformControllerRestApi.ConnectivityConfig, root.AdvantEdgePlatformControllerRestApi.Domain, root.AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
  }
}(this, function(ApiClient, ConnectivityConfig, Domain, NetworkCharacteristics) {
  'use strict';

  /**
   * The Deployment model module.
   * @module model/Deployment
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>Deployment</code>.
   * Network deployment object
   * @alias module:model/Deployment
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>Deployment</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/Deployment} obj Optional instance to populate.
   * @return {module:model/Deployment} The populated <code>Deployment</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('netChar'))
        obj.netChar = NetworkCharacteristics.constructFromObject(data['netChar']);
      if (data.hasOwnProperty('connectivity'))
        obj.connectivity = ConnectivityConfig.constructFromObject(data['connectivity']);
      if (data.hasOwnProperty('interDomainLatency'))
        obj.interDomainLatency = ApiClient.convertToType(data['interDomainLatency'], 'Number');
      if (data.hasOwnProperty('interDomainLatencyVariation'))
        obj.interDomainLatencyVariation = ApiClient.convertToType(data['interDomainLatencyVariation'], 'Number');
      if (data.hasOwnProperty('interDomainThroughput'))
        obj.interDomainThroughput = ApiClient.convertToType(data['interDomainThroughput'], 'Number');
      if (data.hasOwnProperty('interDomainPacketLoss'))
        obj.interDomainPacketLoss = ApiClient.convertToType(data['interDomainPacketLoss'], 'Number');
      if (data.hasOwnProperty('meta'))
        obj.meta = ApiClient.convertToType(data['meta'], {'String': 'String'});
      if (data.hasOwnProperty('userMeta'))
        obj.userMeta = ApiClient.convertToType(data['userMeta'], {'String': 'String'});
      if (data.hasOwnProperty('domains'))
        obj.domains = ApiClient.convertToType(data['domains'], [Domain]);
    }
    return obj;
  }

  /**
   * @member {module:model/NetworkCharacteristics} netChar
   */
  exports.prototype.netChar = undefined;

  /**
   * @member {module:model/ConnectivityConfig} connectivity
   */
  exports.prototype.connectivity = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar latency
   * @member {Number} interDomainLatency
   */
  exports.prototype.interDomainLatency = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar latencyVariation
   * @member {Number} interDomainLatencyVariation
   */
  exports.prototype.interDomainLatencyVariation = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar throughputUl and throughputDl
   * @member {Number} interDomainThroughput
   */
  exports.prototype.interDomainThroughput = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar packetLoss
   * @member {Number} interDomainPacketLoss
   */
  exports.prototype.interDomainPacketLoss = undefined;

  /**
   * Key/Value Pair Map (string, string)
   * @member {Object.<String, String>} meta
   */
  exports.prototype.meta = undefined;

  /**
   * Key/Value Pair Map (string, string)
   * @member {Object.<String, String>} userMeta
   */
  exports.prototype.userMeta = undefined;

  /**
   * @member {Array.<module:model/Domain>} domains
   */
  exports.prototype.domains = undefined;

  return exports;

}));
