# Go API client for client

Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/02.01.01_60/gs_mec013v020101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_ <p>AdvantEDGE supports a selected subset of Location API endpoints (see below)

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/location/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LocationApi* | [**ApByIdGET**](docs/LocationApi.md#apbyidget) | **Get** /queries/zones/{zoneId}/accessPoints/{accessPointId} | Radio Node Location Lookup
*LocationApi* | [**ApGET**](docs/LocationApi.md#apget) | **Get** /queries/zones/{zoneId}/accessPoints | Radio Node Location Lookup
*LocationApi* | [**UserTrackingSubDELETE**](docs/LocationApi.md#usertrackingsubdelete) | **Delete** /subscriptions/userTracking/{subscriptionId} | Cancel a subscription
*LocationApi* | [**UserTrackingSubGET**](docs/LocationApi.md#usertrackingsubget) | **Get** /subscriptions/userTracking/{subscriptionId} | Retrieve subscription information
*LocationApi* | [**UserTrackingSubListGET**](docs/LocationApi.md#usertrackingsublistget) | **Get** /subscriptions/userTracking | Retrieves all active subscriptions to user tracking notifications
*LocationApi* | [**UserTrackingSubPOST**](docs/LocationApi.md#usertrackingsubpost) | **Post** /subscriptions/userTracking | Creates a subscription for user tracking notification
*LocationApi* | [**UserTrackingSubPUT**](docs/LocationApi.md#usertrackingsubput) | **Put** /subscriptions/userTracking/{subscriptionId} | Updates a subscription information
*LocationApi* | [**UsersGET**](docs/LocationApi.md#usersget) | **Get** /queries/users | UE Location Lookup of a specific UE or group of UEs
*LocationApi* | [**ZonalTrafficSubDELETE**](docs/LocationApi.md#zonaltrafficsubdelete) | **Delete** /subscriptions/zonalTraffic/{subscriptionId} | Cancel a subscription
*LocationApi* | [**ZonalTrafficSubGET**](docs/LocationApi.md#zonaltrafficsubget) | **Get** /subscriptions/zonalTraffic/{subscriptionId} | Retrieve subscription information
*LocationApi* | [**ZonalTrafficSubListGET**](docs/LocationApi.md#zonaltrafficsublistget) | **Get** /subscriptions/zonalTraffic | Retrieves all active subscriptions to zonal traffic notifications
*LocationApi* | [**ZonalTrafficSubPOST**](docs/LocationApi.md#zonaltrafficsubpost) | **Post** /subscriptions/zonalTraffic | Creates a subscription for zonal traffic notification
*LocationApi* | [**ZonalTrafficSubPUT**](docs/LocationApi.md#zonaltrafficsubput) | **Put** /subscriptions/zonalTraffic/{subscriptionId} | Updates a subscription information
*LocationApi* | [**ZoneStatusSubDELETE**](docs/LocationApi.md#zonestatussubdelete) | **Delete** /subscriptions/zoneStatus/{subscriptionId} | Cancel a subscription
*LocationApi* | [**ZoneStatusSubGET**](docs/LocationApi.md#zonestatussubget) | **Get** /subscriptions/zoneStatus/{subscriptionId} | Retrieve subscription information
*LocationApi* | [**ZoneStatusSubListGET**](docs/LocationApi.md#zonestatussublistget) | **Get** /subscriptions/zoneStatus | Retrieves all active subscriptions to zone status notifications
*LocationApi* | [**ZoneStatusSubPOST**](docs/LocationApi.md#zonestatussubpost) | **Post** /subscriptions/zoneStatus | Creates a subscription for zone status notification
*LocationApi* | [**ZoneStatusSubPUT**](docs/LocationApi.md#zonestatussubput) | **Put** /subscriptions/zoneStatus/{subscriptionId} | Updates a subscription information
*LocationApi* | [**ZonesGET**](docs/LocationApi.md#zonesget) | **Get** /queries/zones | Zones information Lookup
*LocationApi* | [**ZonesGetById**](docs/LocationApi.md#zonesgetbyid) | **Get** /queries/zones/{zoneId} | Zones information Lookup
*UnsupportedApi* | [**AreaCircleSubDELETE**](docs/UnsupportedApi.md#areacirclesubdelete) | **Delete** /subscriptions/area/circle/{subscriptionId} | Cancel a subscription
*UnsupportedApi* | [**AreaCircleSubGET**](docs/UnsupportedApi.md#areacirclesubget) | **Get** /subscriptions/area/circle/{subscriptionId} | Retrieve subscription information
*UnsupportedApi* | [**AreaCircleSubListGET**](docs/UnsupportedApi.md#areacirclesublistget) | **Get** /subscriptions/area/circle | Retrieves all active subscriptions to area change notifications
*UnsupportedApi* | [**AreaCircleSubPOST**](docs/UnsupportedApi.md#areacirclesubpost) | **Post** /subscriptions/area/circle | Creates a subscription for area change notification
*UnsupportedApi* | [**AreaCircleSubPUT**](docs/UnsupportedApi.md#areacirclesubput) | **Put** /subscriptions/area/circle/{subscriptionId} | Updates a subscription information
*UnsupportedApi* | [**DistanceGET**](docs/UnsupportedApi.md#distanceget) | **Get** /queries/distance | UE Distance Lookup of a specific UE
*UnsupportedApi* | [**DistanceSubDELETE**](docs/UnsupportedApi.md#distancesubdelete) | **Delete** /subscriptions/distance/{subscriptionId} | Cancel a subscription
*UnsupportedApi* | [**DistanceSubGET**](docs/UnsupportedApi.md#distancesubget) | **Get** /subscriptions/distance/{subscriptionId} | Retrieve subscription information
*UnsupportedApi* | [**DistanceSubListGET**](docs/UnsupportedApi.md#distancesublistget) | **Get** /subscriptions/distance | Retrieves all active subscriptions to distance change notifications
*UnsupportedApi* | [**DistanceSubPOST**](docs/UnsupportedApi.md#distancesubpost) | **Post** /subscriptions/distance | Creates a subscription for distance change notification
*UnsupportedApi* | [**DistanceSubPUT**](docs/UnsupportedApi.md#distancesubput) | **Put** /subscriptions/distance/{subscriptionId} | Updates a subscription information
*UnsupportedApi* | [**PeriodicSubDELETE**](docs/UnsupportedApi.md#periodicsubdelete) | **Delete** /subscriptions/periodic/{subscriptionId} | Cancel a subscription
*UnsupportedApi* | [**PeriodicSubGET**](docs/UnsupportedApi.md#periodicsubget) | **Get** /subscriptions/periodic/{subscriptionId} | Retrieve subscription information
*UnsupportedApi* | [**PeriodicSubListGET**](docs/UnsupportedApi.md#periodicsublistget) | **Get** /subscriptions/periodic | Retrieves all active subscriptions to periodic notifications
*UnsupportedApi* | [**PeriodicSubPOST**](docs/UnsupportedApi.md#periodicsubpost) | **Post** /subscriptions/periodic | Creates a subscription for periodic notification
*UnsupportedApi* | [**PeriodicSubPUT**](docs/UnsupportedApi.md#periodicsubput) | **Put** /subscriptions/periodic/{subscriptionId} | Updates a subscription information


## Documentation For Models

 - [AccessPointInfo](docs/AccessPointInfo.md)
 - [AccessPointList](docs/AccessPointList.md)
 - [CallbackReference](docs/CallbackReference.md)
 - [CircleNotificationSubscription](docs/CircleNotificationSubscription.md)
 - [ConnectionType](docs/ConnectionType.md)
 - [DistanceCriteria](docs/DistanceCriteria.md)
 - [DistanceNotificationSubscription](docs/DistanceNotificationSubscription.md)
 - [EnteringLeavingCriteria](docs/EnteringLeavingCriteria.md)
 - [InlineAccessPointInfo](docs/InlineAccessPointInfo.md)
 - [InlineAccessPointList](docs/InlineAccessPointList.md)
 - [InlineCircleNotificationSubscription](docs/InlineCircleNotificationSubscription.md)
 - [InlineDistanceNotificationSubscription](docs/InlineDistanceNotificationSubscription.md)
 - [InlineNotificationSubscriptionList](docs/InlineNotificationSubscriptionList.md)
 - [InlinePeriodicNotificationSubscription](docs/InlinePeriodicNotificationSubscription.md)
 - [InlineProblemDetails](docs/InlineProblemDetails.md)
 - [InlineProblemDetailsRequired](docs/InlineProblemDetailsRequired.md)
 - [InlineSubscriptionNotification](docs/InlineSubscriptionNotification.md)
 - [InlineTerminalDistance](docs/InlineTerminalDistance.md)
 - [InlineUserList](docs/InlineUserList.md)
 - [InlineUserTrackingSubscription](docs/InlineUserTrackingSubscription.md)
 - [InlineZonalPresenceNotification](docs/InlineZonalPresenceNotification.md)
 - [InlineZonalTrafficSubscription](docs/InlineZonalTrafficSubscription.md)
 - [InlineZoneInfo](docs/InlineZoneInfo.md)
 - [InlineZoneList](docs/InlineZoneList.md)
 - [InlineZoneStatusNotification](docs/InlineZoneStatusNotification.md)
 - [InlineZoneStatusSubscription](docs/InlineZoneStatusSubscription.md)
 - [Link](docs/Link.md)
 - [LocationInfo](docs/LocationInfo.md)
 - [LocationInfoVelocity](docs/LocationInfoVelocity.md)
 - [NotificationFormat](docs/NotificationFormat.md)
 - [NotificationSubscriptionList](docs/NotificationSubscriptionList.md)
 - [OperationStatus](docs/OperationStatus.md)
 - [PeriodicNotificationSubscription](docs/PeriodicNotificationSubscription.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [RetrievalStatus](docs/RetrievalStatus.md)
 - [ServiceError](docs/ServiceError.md)
 - [SubscriptionCancellationNotification](docs/SubscriptionCancellationNotification.md)
 - [SubscriptionNotification](docs/SubscriptionNotification.md)
 - [TerminalDistance](docs/TerminalDistance.md)
 - [TerminalLocation](docs/TerminalLocation.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [UserEventType](docs/UserEventType.md)
 - [UserInfo](docs/UserInfo.md)
 - [UserList](docs/UserList.md)
 - [UserTrackingSubscription](docs/UserTrackingSubscription.md)
 - [ZonalPresenceNotification](docs/ZonalPresenceNotification.md)
 - [ZonalTrafficSubscription](docs/ZonalTrafficSubscription.md)
 - [ZoneInfo](docs/ZoneInfo.md)
 - [ZoneList](docs/ZoneList.md)
 - [ZoneStatusNotification](docs/ZoneStatusNotification.md)
 - [ZoneStatusSubscription](docs/ZoneStatusSubscription.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

