# advant_edge_gis_engine_rest_api

AdvantEdgeGisEngineRestApi - JavaScript client for advant_edge_gis_engine_rest_api
This API allows to control geo-spatial behavior and simulation. <p>**Micro-service**<br>[meep-gis-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-gis-engine) <p>**Type & Usage**<br>Platform runtime interface to control geo-spatial behavior and simulation <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install advant_edge_gis_engine_rest_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your advant_edge_gis_engine_rest_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('advant_edge_gis_engine_rest_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var AdvantEdgeGisEngineRestApi = require('advant_edge_gis_engine_rest_api');

var api = new AdvantEdgeGisEngineRestApi.AutomationApi()

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.getAutomationState(callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/gis/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdvantEdgeGisEngineRestApi.AutomationApi* | [**getAutomationState**](docs/AutomationApi.md#getAutomationState) | **GET** /automation | Get automation state
*AdvantEdgeGisEngineRestApi.AutomationApi* | [**getAutomationStateByName**](docs/AutomationApi.md#getAutomationStateByName) | **GET** /automation/{type} | Get automation state
*AdvantEdgeGisEngineRestApi.AutomationApi* | [**setAutomationStateByName**](docs/AutomationApi.md#setAutomationStateByName) | **POST** /automation/{type} | Set automation state
*AdvantEdgeGisEngineRestApi.GeospatialDataApi* | [**deleteGeoDataByName**](docs/GeospatialDataApi.md#deleteGeoDataByName) | **DELETE** /geodata/{assetName} | Delete geospatial data
*AdvantEdgeGisEngineRestApi.GeospatialDataApi* | [**getAssetData**](docs/GeospatialDataApi.md#getAssetData) | **GET** /geodata | Get geospatial data
*AdvantEdgeGisEngineRestApi.GeospatialDataApi* | [**getGeoDataByName**](docs/GeospatialDataApi.md#getGeoDataByName) | **GET** /geodata/{assetName} | Get geospatial data
*AdvantEdgeGisEngineRestApi.GeospatialDataApi* | [**updateGeoDataByName**](docs/GeospatialDataApi.md#updateGeoDataByName) | **POST** /geodata/{assetName} | Create/Update geospatial data


## Documentation for Models

 - [AdvantEdgeGisEngineRestApi.AutomationState](docs/AutomationState.md)
 - [AdvantEdgeGisEngineRestApi.AutomationStateList](docs/AutomationStateList.md)
 - [AdvantEdgeGisEngineRestApi.GeoData](docs/GeoData.md)
 - [AdvantEdgeGisEngineRestApi.GeoDataAssetList](docs/GeoDataAssetList.md)
 - [AdvantEdgeGisEngineRestApi.LineString](docs/LineString.md)
 - [AdvantEdgeGisEngineRestApi.Point](docs/Point.md)
 - [AdvantEdgeGisEngineRestApi.GeoDataAsset](docs/GeoDataAsset.md)


## Documentation for Authorization

 All endpoints do not require authorization.

