/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Radio Network Information Service REST API
 *
 * Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/02.01.01_60/gs_MEC012v020101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 2.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

type NrMeasRepUeNotification struct {
	// 0 to N identifiers to associate the event for a specific UE or flow.
	AssociateId []AssociateId `json:"associateId,omitempty"`
	// This parameter can be repeated to contain measurement information of all the neighbouring cells up to N. It shall not be included if nrNeighCellMeasInfo is included.
	EutraNeighCellMeasInfo []NrMeasRepUeNotificationEutraNeighCellMeasInfo `json:"eutraNeighCellMeasInfo,omitempty"`
	// Shall be set to \"NrMeasRepUeNotification\".
	NotificationType string `json:"notificationType"`
	// This parameter can be repeated to contain measurement information of all the neighbouring cells up to N. It shall not be included if eutraNeighCellMeasInfo is included.
	NrNeighCellMeasInfo []NrMeasRepUeNotificationNrNeighCellMeasInfo `json:"nrNeighCellMeasInfo,omitempty"`
	// This parameter can be repeated to contain information of all the serving cells up to N.
	ServCellMeasInfo []NrMeasRepUeNotificationServCellMeasInfo `json:"servCellMeasInfo,omitempty"`
	TimeStamp        *TimeStamp                                `json:"timeStamp,omitempty"`
	TriggerNr        *TriggerNr                                `json:"triggerNr"`
}
