/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/CellularPoaConfig', 'model/GeoData', 'model/NetworkCharacteristics', 'model/PhysicalLocation', 'model/Poa4GConfig', 'model/Poa5GConfig', 'model/PoaWifiConfig'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./CellularPoaConfig'), require('./GeoData'), require('./NetworkCharacteristics'), require('./PhysicalLocation'), require('./Poa4GConfig'), require('./Poa5GConfig'), require('./PoaWifiConfig'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeSandboxControllerRestApi) {
      root.AdvantEdgeSandboxControllerRestApi = {};
    }
    root.AdvantEdgeSandboxControllerRestApi.NetworkLocation = factory(root.AdvantEdgeSandboxControllerRestApi.ApiClient, root.AdvantEdgeSandboxControllerRestApi.CellularPoaConfig, root.AdvantEdgeSandboxControllerRestApi.GeoData, root.AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics, root.AdvantEdgeSandboxControllerRestApi.PhysicalLocation, root.AdvantEdgeSandboxControllerRestApi.Poa4GConfig, root.AdvantEdgeSandboxControllerRestApi.Poa5GConfig, root.AdvantEdgeSandboxControllerRestApi.PoaWifiConfig);
  }
}(this, function(ApiClient, CellularPoaConfig, GeoData, NetworkCharacteristics, PhysicalLocation, Poa4GConfig, Poa5GConfig, PoaWifiConfig) {
  'use strict';

  /**
   * The NetworkLocation model module.
   * @module model/NetworkLocation
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>NetworkLocation</code>.
   * Logical network location object
   * @alias module:model/NetworkLocation
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>NetworkLocation</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/NetworkLocation} obj Optional instance to populate.
   * @return {module:model/NetworkLocation} The populated <code>NetworkLocation</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('id'))
        obj.id = ApiClient.convertToType(data['id'], 'String');
      if (data.hasOwnProperty('name'))
        obj.name = ApiClient.convertToType(data['name'], 'String');
      if (data.hasOwnProperty('type'))
        obj.type = ApiClient.convertToType(data['type'], 'String');
      if (data.hasOwnProperty('netChar'))
        obj.netChar = NetworkCharacteristics.constructFromObject(data['netChar']);
      if (data.hasOwnProperty('terminalLinkLatency'))
        obj.terminalLinkLatency = ApiClient.convertToType(data['terminalLinkLatency'], 'Number');
      if (data.hasOwnProperty('terminalLinkLatencyVariation'))
        obj.terminalLinkLatencyVariation = ApiClient.convertToType(data['terminalLinkLatencyVariation'], 'Number');
      if (data.hasOwnProperty('terminalLinkThroughput'))
        obj.terminalLinkThroughput = ApiClient.convertToType(data['terminalLinkThroughput'], 'Number');
      if (data.hasOwnProperty('terminalLinkPacketLoss'))
        obj.terminalLinkPacketLoss = ApiClient.convertToType(data['terminalLinkPacketLoss'], 'Number');
      if (data.hasOwnProperty('meta'))
        obj.meta = ApiClient.convertToType(data['meta'], {'String': 'String'});
      if (data.hasOwnProperty('userMeta'))
        obj.userMeta = ApiClient.convertToType(data['userMeta'], {'String': 'String'});
      if (data.hasOwnProperty('cellularPoaConfig'))
        obj.cellularPoaConfig = CellularPoaConfig.constructFromObject(data['cellularPoaConfig']);
      if (data.hasOwnProperty('poa4GConfig'))
        obj.poa4GConfig = Poa4GConfig.constructFromObject(data['poa4GConfig']);
      if (data.hasOwnProperty('poa5GConfig'))
        obj.poa5GConfig = Poa5GConfig.constructFromObject(data['poa5GConfig']);
      if (data.hasOwnProperty('poaWifiConfig'))
        obj.poaWifiConfig = PoaWifiConfig.constructFromObject(data['poaWifiConfig']);
      if (data.hasOwnProperty('geoData'))
        obj.geoData = GeoData.constructFromObject(data['geoData']);
      if (data.hasOwnProperty('physicalLocations'))
        obj.physicalLocations = ApiClient.convertToType(data['physicalLocations'], [PhysicalLocation]);
    }
    return obj;
  }

  /**
   * Unique network location ID
   * @member {String} id
   */
  exports.prototype.id = undefined;

  /**
   * Network location name
   * @member {String} name
   */
  exports.prototype.name = undefined;

  /**
   * Network location type
   * @member {module:model/NetworkLocation.TypeEnum} type
   */
  exports.prototype.type = undefined;

  /**
   * @member {module:model/NetworkCharacteristics} netChar
   */
  exports.prototype.netChar = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar latency
   * @member {Number} terminalLinkLatency
   */
  exports.prototype.terminalLinkLatency = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar latencyVariation
   * @member {Number} terminalLinkLatencyVariation
   */
  exports.prototype.terminalLinkLatencyVariation = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar throughputUl and throughputDl
   * @member {Number} terminalLinkThroughput
   */
  exports.prototype.terminalLinkThroughput = undefined;

  /**
   * **DEPRECATED** As of release 1.5.0, replaced by netChar packetLoss
   * @member {Number} terminalLinkPacketLoss
   */
  exports.prototype.terminalLinkPacketLoss = undefined;

  /**
   * Key/Value Pair Map (string, string)
   * @member {Object.<String, String>} meta
   */
  exports.prototype.meta = undefined;

  /**
   * Key/Value Pair Map (string, string)
   * @member {Object.<String, String>} userMeta
   */
  exports.prototype.userMeta = undefined;

  /**
   * @member {module:model/CellularPoaConfig} cellularPoaConfig
   */
  exports.prototype.cellularPoaConfig = undefined;

  /**
   * @member {module:model/Poa4GConfig} poa4GConfig
   */
  exports.prototype.poa4GConfig = undefined;

  /**
   * @member {module:model/Poa5GConfig} poa5GConfig
   */
  exports.prototype.poa5GConfig = undefined;

  /**
   * @member {module:model/PoaWifiConfig} poaWifiConfig
   */
  exports.prototype.poaWifiConfig = undefined;

  /**
   * @member {module:model/GeoData} geoData
   */
  exports.prototype.geoData = undefined;

  /**
   * @member {Array.<module:model/PhysicalLocation>} physicalLocations
   */
  exports.prototype.physicalLocations = undefined;


  /**
   * Allowed values for the <code>type</code> property.
   * @enum {String}
   * @readonly
   */
  exports.TypeEnum = {
    /**
     * value: "POA"
     * @const
     */
    POA: "POA",

    /**
     * value: "POA-4G"
     * @const
     */
    pOA4G: "POA-4G",

    /**
     * value: "POA-5G"
     * @const
     */
    pOA5G: "POA-5G",

    /**
     * value: "POA-WIFI"
     * @const
     */
    POA_WIFI: "POA-WIFI",

    /**
     * value: "DEFAULT"
     * @const
     */
    DEFAULT: "DEFAULT"
  };

  return exports;

}));
