# advant_edge_platform_controller_rest_api

AdvantEdgePlatformControllerRestApi - JavaScript client for advant_edge_platform_controller_rest_api
This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install advant_edge_platform_controller_rest_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your advant_edge_platform_controller_rest_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('advant_edge_platform_controller_rest_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var AdvantEdgePlatformControllerRestApi = require('advant_edge_platform_controller_rest_api');

var api = new AdvantEdgePlatformControllerRestApi.SandboxControlApi()

var config = new AdvantEdgePlatformControllerRestApi.SandboxConfig(); // {SandboxConfig} Sandbox configuration information


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.createSandbox(config, callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/platform-ctrl/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdvantEdgePlatformControllerRestApi.SandboxControlApi* | [**createSandbox**](docs/SandboxControlApi.md#createSandbox) | **POST** /sandboxes | Create a new sandbox
*AdvantEdgePlatformControllerRestApi.SandboxControlApi* | [**createSandboxWithName**](docs/SandboxControlApi.md#createSandboxWithName) | **POST** /sandboxes/{name} | Create a new sandbox
*AdvantEdgePlatformControllerRestApi.SandboxControlApi* | [**deleteSandbox**](docs/SandboxControlApi.md#deleteSandbox) | **DELETE** /sandboxes/{name} | Delete a specific sandbox
*AdvantEdgePlatformControllerRestApi.SandboxControlApi* | [**deleteSandboxList**](docs/SandboxControlApi.md#deleteSandboxList) | **DELETE** /sandboxes | Delete all active sandboxes
*AdvantEdgePlatformControllerRestApi.SandboxControlApi* | [**getSandbox**](docs/SandboxControlApi.md#getSandbox) | **GET** /sandboxes/{name} | Get a specific sandbox
*AdvantEdgePlatformControllerRestApi.SandboxControlApi* | [**getSandboxList**](docs/SandboxControlApi.md#getSandboxList) | **GET** /sandboxes | Get all active sandboxes
*AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi* | [**createScenario**](docs/ScenarioConfigurationApi.md#createScenario) | **POST** /scenarios/{name} | Add a scenario
*AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi* | [**deleteScenario**](docs/ScenarioConfigurationApi.md#deleteScenario) | **DELETE** /scenarios/{name} | Delete a scenario
*AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi* | [**deleteScenarioList**](docs/ScenarioConfigurationApi.md#deleteScenarioList) | **DELETE** /scenarios | Delete all scenarios
*AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi* | [**getScenario**](docs/ScenarioConfigurationApi.md#getScenario) | **GET** /scenarios/{name} | Get a specific scenario
*AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi* | [**getScenarioList**](docs/ScenarioConfigurationApi.md#getScenarioList) | **GET** /scenarios | Get all scenarios
*AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi* | [**setScenario**](docs/ScenarioConfigurationApi.md#setScenario) | **PUT** /scenarios/{name} | Update a scenario
*AdvantEdgePlatformControllerRestApi.UserAuthenticationApi* | [**authorize**](docs/UserAuthenticationApi.md#authorize) | **GET** /authorize | OAuth authorization response endpoint
*AdvantEdgePlatformControllerRestApi.UserAuthenticationApi* | [**loginOAuth**](docs/UserAuthenticationApi.md#loginOAuth) | **GET** /login | Initiate OAuth login procedure
*AdvantEdgePlatformControllerRestApi.UserAuthenticationApi* | [**loginUser**](docs/UserAuthenticationApi.md#loginUser) | **POST** /login | Start a session
*AdvantEdgePlatformControllerRestApi.UserAuthenticationApi* | [**logoutUser**](docs/UserAuthenticationApi.md#logoutUser) | **GET** /logout | Terminate a session
*AdvantEdgePlatformControllerRestApi.UserAuthenticationApi* | [**triggerWatchdog**](docs/UserAuthenticationApi.md#triggerWatchdog) | **POST** /watchdog | Send heartbeat to watchdog


## Documentation for Models

 - [AdvantEdgePlatformControllerRestApi.CellularDomainConfig](docs/CellularDomainConfig.md)
 - [AdvantEdgePlatformControllerRestApi.CellularPoaConfig](docs/CellularPoaConfig.md)
 - [AdvantEdgePlatformControllerRestApi.CpuConfig](docs/CpuConfig.md)
 - [AdvantEdgePlatformControllerRestApi.Deployment](docs/Deployment.md)
 - [AdvantEdgePlatformControllerRestApi.Domain](docs/Domain.md)
 - [AdvantEdgePlatformControllerRestApi.EgressService](docs/EgressService.md)
 - [AdvantEdgePlatformControllerRestApi.ExternalConfig](docs/ExternalConfig.md)
 - [AdvantEdgePlatformControllerRestApi.GeoData](docs/GeoData.md)
 - [AdvantEdgePlatformControllerRestApi.GpuConfig](docs/GpuConfig.md)
 - [AdvantEdgePlatformControllerRestApi.IngressService](docs/IngressService.md)
 - [AdvantEdgePlatformControllerRestApi.LineString](docs/LineString.md)
 - [AdvantEdgePlatformControllerRestApi.MemoryConfig](docs/MemoryConfig.md)
 - [AdvantEdgePlatformControllerRestApi.NetworkCharacteristics](docs/NetworkCharacteristics.md)
 - [AdvantEdgePlatformControllerRestApi.NetworkLocation](docs/NetworkLocation.md)
 - [AdvantEdgePlatformControllerRestApi.PhysicalLocation](docs/PhysicalLocation.md)
 - [AdvantEdgePlatformControllerRestApi.Poa4GConfig](docs/Poa4GConfig.md)
 - [AdvantEdgePlatformControllerRestApi.Poa5GConfig](docs/Poa5GConfig.md)
 - [AdvantEdgePlatformControllerRestApi.PoaWifiConfig](docs/PoaWifiConfig.md)
 - [AdvantEdgePlatformControllerRestApi.Point](docs/Point.md)
 - [AdvantEdgePlatformControllerRestApi.Process](docs/Process.md)
 - [AdvantEdgePlatformControllerRestApi.Sandbox](docs/Sandbox.md)
 - [AdvantEdgePlatformControllerRestApi.SandboxConfig](docs/SandboxConfig.md)
 - [AdvantEdgePlatformControllerRestApi.SandboxList](docs/SandboxList.md)
 - [AdvantEdgePlatformControllerRestApi.Scenario](docs/Scenario.md)
 - [AdvantEdgePlatformControllerRestApi.ScenarioConfig](docs/ScenarioConfig.md)
 - [AdvantEdgePlatformControllerRestApi.ScenarioList](docs/ScenarioList.md)
 - [AdvantEdgePlatformControllerRestApi.ServiceConfig](docs/ServiceConfig.md)
 - [AdvantEdgePlatformControllerRestApi.ServicePort](docs/ServicePort.md)
 - [AdvantEdgePlatformControllerRestApi.Zone](docs/Zone.md)


## Documentation for Authorization

 All endpoints do not require authorization.

