# Go API client for client

Mobility Group Service allows to form groups formed multiple edge application instances and share user states automatically withing the group <p>**Micro-service**<br>[meep-mg-manager](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-mg-manager) <p>**Type & Usage**<br>Edge Service used by edge applications to share user state between the  Mobility Group members <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/mgm/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MembershipApi* | [**CreateMobilityGroup**](docs/MembershipApi.md#createmobilitygroup) | **Post** /mg/{mgName} | Add new Mobility Group
*MembershipApi* | [**CreateMobilityGroupApp**](docs/MembershipApi.md#createmobilitygroupapp) | **Post** /mg/{mgName}/app/{appId} | Add new Mobility Group App
*MembershipApi* | [**CreateMobilityGroupUe**](docs/MembershipApi.md#createmobilitygroupue) | **Post** /mg/{mgName}/app/{appId}/ue | Add UE to group tracking list
*MembershipApi* | [**DeleteMobilityGroup**](docs/MembershipApi.md#deletemobilitygroup) | **Delete** /mg/{mgName} | Delete Mobility Group
*MembershipApi* | [**DeleteMobilityGroupApp**](docs/MembershipApi.md#deletemobilitygroupapp) | **Delete** /mg/{mgName}/app/{appId} | Delete Mobility Group App
*MembershipApi* | [**GetMobilityGroup**](docs/MembershipApi.md#getmobilitygroup) | **Get** /mg/{mgName} | Retrieve Mobility Groups with provided name
*MembershipApi* | [**GetMobilityGroupApp**](docs/MembershipApi.md#getmobilitygroupapp) | **Get** /mg/{mgName}/app/{appId} | Retrieve App information using provided Mobility Group Name &amp; App ID
*MembershipApi* | [**GetMobilityGroupAppList**](docs/MembershipApi.md#getmobilitygroupapplist) | **Get** /mg/{mgName}/app | Retrieve list of Apps in provided Mobility Group
*MembershipApi* | [**GetMobilityGroupList**](docs/MembershipApi.md#getmobilitygrouplist) | **Get** /mg | Retrieve list of Mobility Groups
*MembershipApi* | [**SetMobilityGroup**](docs/MembershipApi.md#setmobilitygroup) | **Put** /mg/{mgName} | Update Mobility Group
*MembershipApi* | [**SetMobilityGroupApp**](docs/MembershipApi.md#setmobilitygroupapp) | **Put** /mg/{mgName}/app/{appId} | Update Mobility GroupApp
*StateTransferApi* | [**TransferAppState**](docs/StateTransferApi.md#transferappstate) | **Post** /mg/{mgName}/app/{appId}/state | Send state to transfer to peers


## Documentation For Models

 - [MobilityGroup](docs/MobilityGroup.md)
 - [MobilityGroupApp](docs/MobilityGroupApp.md)
 - [MobilityGroupAppState](docs/MobilityGroupAppState.md)
 - [MobilityGroupUe](docs/MobilityGroupUe.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

