# Go API client for client

This API enables the Radio Network Information Service to post notification events to subscribers' applications <p>**Micro-service**<br>None <p>**Type & Usage**<br>User's Edge Applications subscribing to Radio Network Information events must implement this API <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_ <p>**Note**<br>This API is not exposed by default on the AdvantEDGE platform

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/rni/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*NotificationsApi* | [**PostCellChangeNotification**](docs/NotificationsApi.md#postcellchangenotification) | **Post** /notifications/cell_change/{subscriptionId} | This operation is used by the AdvantEDGE RNI Service to issue a callback notification to inform about teh cell change of a UE subscription
*NotificationsApi* | [**PostExpiryNotification**](docs/NotificationsApi.md#postexpirynotification) | **Post** /notifications/expiry/{subscriptionId} | This operation is used by the AdvantEDGE RNI Service to issue a notification with regards to expiry of an existing subscription


## Documentation For Models

 - [AssociateId](docs/AssociateId.md)
 - [CellChangeNotification](docs/CellChangeNotification.md)
 - [Ecgi](docs/Ecgi.md)
 - [ExpiryNotification](docs/ExpiryNotification.md)
 - [HoStatus](docs/HoStatus.md)
 - [Link](docs/Link.md)
 - [Plmn](docs/Plmn.md)
 - [TempUeId](docs/TempUeId.md)
 - [TimeStamp](docs/TimeStamp.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

