/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Radio Network Information Service REST API
 *
 * Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/01.01.01_60/gs_MEC012v010101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.1.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

// SubscriptionType : Numeric value corresponding to specified type of subscription.
type SubscriptionType string

// List of SubscriptionType
const (
	RESERVED_SUBSCRIPTION_TYPE_SubscriptionType SubscriptionType = "RESERVED_SUBSCRIPTION_TYPE"
	CELL_CHANGE_SubscriptionType                SubscriptionType = "CELL_CHANGE"
	RAB_ESTABLISHMENT_SubscriptionType          SubscriptionType = "RAB_ESTABLISHMENT"
	RAB_MODIFICATION_SubscriptionType           SubscriptionType = "RAB_MODIFICATION"
	RAB_RELEASE_SubscriptionType                SubscriptionType = "RAB_RELEASE"
	MEAS_REPORT_UE_SubscriptionType             SubscriptionType = "MEAS_REPORT_UE"
	MEAS_TIMING_ADVANCE_SubscriptionType        SubscriptionType = "MEAS_TIMING_ADVANCE"
	CA_RECONF_SubscriptionType                  SubscriptionType = "CA_RECONF"
	S1_BEARE_SubscriptionType                   SubscriptionType = "S1_BEARE"
)
