# \DefaultApi

All URIs are relative to *http://localhost/rni/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**CaReConfSubscriptionSubscriptionsGET**](DefaultApi.md#CaReConfSubscriptionSubscriptionsGET) | **Get** /subscriptions/ca_reconf/{subscriptionId} | 
[**CaReConfSubscriptionSubscriptionsPOST**](DefaultApi.md#CaReConfSubscriptionSubscriptionsPOST) | **Post** /subscriptions/ca_reconf | 
[**CaReConfSubscriptionSubscriptionsPUT**](DefaultApi.md#CaReConfSubscriptionSubscriptionsPUT) | **Put** /subscriptions/ca_reconf/{subscriptionId} | 
[**CaReConfSubscriptionsSubscrIdDELETE**](DefaultApi.md#CaReConfSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/ca_reconf/{subscriptionId} | 
[**CellChangeSubscriptionsGET**](DefaultApi.md#CellChangeSubscriptionsGET) | **Get** /subscriptions/cell_change/{subscriptionId} | 
[**CellChangeSubscriptionsPOST**](DefaultApi.md#CellChangeSubscriptionsPOST) | **Post** /subscriptions/cell_change | 
[**CellChangeSubscriptionsPUT**](DefaultApi.md#CellChangeSubscriptionsPUT) | **Put** /subscriptions/cell_change/{subscriptionId} | 
[**CellChangeSubscriptionsSubscrIdDELETE**](DefaultApi.md#CellChangeSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/cell_change/{subscriptionId} | 
[**MeasRepUeReportSubscriptionsPUT**](DefaultApi.md#MeasRepUeReportSubscriptionsPUT) | **Put** /subscriptions/meas_rep_ue/{subscriptionId} | 
[**MeasRepUeSubscriptionsGET**](DefaultApi.md#MeasRepUeSubscriptionsGET) | **Get** /subscriptions/meas_rep_ue/{subscriptionId} | 
[**MeasRepUeSubscriptionsPOST**](DefaultApi.md#MeasRepUeSubscriptionsPOST) | **Post** /subscriptions/meas_rep_ue | 
[**MeasRepUeSubscriptionsSubscrIdDELETE**](DefaultApi.md#MeasRepUeSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/meas_rep_ue/{subscriptionId} | 
[**MeasTaSubscriptionsGET**](DefaultApi.md#MeasTaSubscriptionsGET) | **Get** /subscriptions/ta/{subscriptionId} | 
[**MeasTaSubscriptionsPOST**](DefaultApi.md#MeasTaSubscriptionsPOST) | **Post** /subscriptions/ta | 
[**MeasTaSubscriptionsPUT**](DefaultApi.md#MeasTaSubscriptionsPUT) | **Put** /subscriptions/ta/{subscriptionId} | 
[**MeasTaSubscriptionsSubscrIdDELETE**](DefaultApi.md#MeasTaSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/ta/{subscriptionId} | 
[**PlmnInfoGET**](DefaultApi.md#PlmnInfoGET) | **Get** /queries/plmn_info | 
[**RabEstSubscriptionSubscriptionsGET**](DefaultApi.md#RabEstSubscriptionSubscriptionsGET) | **Get** /subscriptions/rab_est/{subscriptionId} | 
[**RabEstSubscriptionSubscriptionsPOST**](DefaultApi.md#RabEstSubscriptionSubscriptionsPOST) | **Post** /subscriptions/rab_est | 
[**RabEstSubscriptionSubscriptionsPUT**](DefaultApi.md#RabEstSubscriptionSubscriptionsPUT) | **Put** /subscriptions/rab_est/{subscriptionId} | 
[**RabEstSubscriptionsSubscrIdDELETE**](DefaultApi.md#RabEstSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/rab_est/{subscriptionId} | 
[**RabInfoGET**](DefaultApi.md#RabInfoGET) | **Get** /queries/rab_info | 
[**RabModSubscriptionSubscriptionsGET**](DefaultApi.md#RabModSubscriptionSubscriptionsGET) | **Get** /subscriptions/rab_mod/{subscriptionId} | 
[**RabModSubscriptionSubscriptionsPOST**](DefaultApi.md#RabModSubscriptionSubscriptionsPOST) | **Post** /subscriptions/rab_mod | 
[**RabModSubscriptionSubscriptionsPUT**](DefaultApi.md#RabModSubscriptionSubscriptionsPUT) | **Put** /subscriptions/rab_mod/{subscriptionId} | 
[**RabModSubscriptionsSubscrIdDELETE**](DefaultApi.md#RabModSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/rab_mod/{subscriptionId} | 
[**RabRelSubscriptionSubscriptionsGET**](DefaultApi.md#RabRelSubscriptionSubscriptionsGET) | **Get** /subscriptions/rab_rel/{subscriptionId} | 
[**RabRelSubscriptionSubscriptionsPOST**](DefaultApi.md#RabRelSubscriptionSubscriptionsPOST) | **Post** /subscriptions/rab_rel | 
[**RabRelSubscriptionSubscriptionsPUT**](DefaultApi.md#RabRelSubscriptionSubscriptionsPUT) | **Put** /subscriptions/rab_rel/{subscriptionId} | 
[**RabRelSubscriptionsSubscrIdDELETE**](DefaultApi.md#RabRelSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/rab_rel/{subscriptionId} | 
[**S1BearerInfoGET**](DefaultApi.md#S1BearerInfoGET) | **Get** /queries/s1_bearer_info | 
[**S1BearerSubscriptionSubscriptionsGET**](DefaultApi.md#S1BearerSubscriptionSubscriptionsGET) | **Get** /subscriptions/s1_bearer/{subscriptionId} | 
[**S1BearerSubscriptionSubscriptionsPOST**](DefaultApi.md#S1BearerSubscriptionSubscriptionsPOST) | **Post** /subscriptions/s1_bearer | 
[**S1BearerSubscriptionSubscriptionsPUT**](DefaultApi.md#S1BearerSubscriptionSubscriptionsPUT) | **Put** /subscriptions/s1_bearer/{subscriptionId} | 
[**S1BearerSubscriptionsSubscrIdDELETE**](DefaultApi.md#S1BearerSubscriptionsSubscrIdDELETE) | **Delete** /subscriptions/s1_bearer/{subscriptionId} | 
[**SubscriptionLinkListSubscriptionsCcGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsCcGET) | **Get** /subscriptions/cell_change | 
[**SubscriptionLinkListSubscriptionsCrGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsCrGET) | **Get** /subscriptions/ca_reconf | 
[**SubscriptionLinkListSubscriptionsGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsGET) | **Get** /subscriptions/ | 
[**SubscriptionLinkListSubscriptionsMrGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsMrGET) | **Get** /subscriptions/meas_rep_ue | 
[**SubscriptionLinkListSubscriptionsReGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsReGET) | **Get** /subscriptions/rab_est | 
[**SubscriptionLinkListSubscriptionsRmGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsRmGET) | **Get** /subscriptions/rab_mod | 
[**SubscriptionLinkListSubscriptionsRrGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsRrGET) | **Get** /subscriptions/rab_rel | 
[**SubscriptionLinkListSubscriptionsS1GET**](DefaultApi.md#SubscriptionLinkListSubscriptionsS1GET) | **Get** /subscriptions/s1_bearer | 
[**SubscriptionLinkListSubscriptionsTaGET**](DefaultApi.md#SubscriptionLinkListSubscriptionsTaGET) | **Get** /subscriptions/ta | 


# **CaReConfSubscriptionSubscriptionsGET**
> InlineResponse20010 CaReConfSubscriptionSubscriptionsGET(ctx, subscriptionId)


Gets a subscription to Carrier Aggregation Reconfiguration notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse20010**](inline_response_200_10.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CaReConfSubscriptionSubscriptionsPOST**
> InlineResponse2017 CaReConfSubscriptionSubscriptionsPOST(ctx, caReConfSubscriptionPost)


Creates a subscription to Carrier Aggregation Reconfiguration notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **caReConfSubscriptionPost** | [**CaReConfSubscriptionPost1**](CaReConfSubscriptionPost1.md)| Use to creates a subscription to Carrier Aggregation Reconfiguration notifications based on the filter criteria | 

### Return type

[**InlineResponse2017**](inline_response_201_7.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CaReConfSubscriptionSubscriptionsPUT**
> CaReConfSubscription1 CaReConfSubscriptionSubscriptionsPUT(ctx, subscriptionId, caReConfSubscription)


Updates a subscription to Carrier Aggregation Reconfiguration notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **caReConfSubscription** | [**CaReConfSubscription1**](CaReConfSubscription1.md)| Use to creates a subscription to Carrier Aggregation Reconfiguration notifications based on the filter criteria | 

### Return type

[**CaReConfSubscription1**](CaReConfSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CaReConfSubscriptionsSubscrIdDELETE**
> CaReConfSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CellChangeSubscriptionsGET**
> InlineResponse2004 CellChangeSubscriptionsGET(ctx, subscriptionId)


Get cell change subscription information

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2004**](inline_response_200_4.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CellChangeSubscriptionsPOST**
> InlineResponse201 CellChangeSubscriptionsPOST(ctx, cellChangeSubscriptionPost)


Creates a subscription to cell change notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **cellChangeSubscriptionPost** | [**CellChangeSubscriptionPost1**](CellChangeSubscriptionPost1.md)| Use to creates a subscription to cell change notifications based on the    filter criteria | 

### Return type

[**InlineResponse201**](inline_response_201.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CellChangeSubscriptionsPUT**
> CellChangeSubscription1 CellChangeSubscriptionsPUT(ctx, cellChangeSubscription, subscriptionId)


Updates a subscription to cell change notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **cellChangeSubscription** | [**CellChangeSubscription1**](CellChangeSubscription1.md)| Use to creates a subscription to cell change notifications based on the filter criteria | 
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**CellChangeSubscription1**](CellChangeSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **CellChangeSubscriptionsSubscrIdDELETE**
> CellChangeSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasRepUeReportSubscriptionsPUT**
> MeasRepUeSubscription1 MeasRepUeReportSubscriptionsPUT(ctx, subscriptionId, measRepUeSubscription)


Updates a subscription to UE measurement report notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **measRepUeSubscription** | [**MeasRepUeSubscription1**](MeasRepUeSubscription1.md)| Use to creates a subscription to UE measurement report notifications based on the filter criteria | 

### Return type

[**MeasRepUeSubscription1**](MeasRepUeSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasRepUeSubscriptionsGET**
> InlineResponse2006 MeasRepUeSubscriptionsGET(ctx, subscriptionId)


Gets a subscription to UE measurement report notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2006**](inline_response_200_6.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasRepUeSubscriptionsPOST**
> InlineResponse2013 MeasRepUeSubscriptionsPOST(ctx, measRepUeSubscriptionPost)


Creates a subscription to UE measurement report notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **measRepUeSubscriptionPost** | [**MeasRepUeSubscriptionPost1**](MeasRepUeSubscriptionPost1.md)| Use to creates a subscription to UE measurement report notifications based on the filter criteria | 

### Return type

[**InlineResponse2013**](inline_response_201_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasRepUeSubscriptionsSubscrIdDELETE**
> MeasRepUeSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasTaSubscriptionsGET**
> InlineResponse2005 MeasTaSubscriptionsGET(ctx, subscriptionId)


Gets UE Timing Advance subscription information from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2005**](inline_response_200_5.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasTaSubscriptionsPOST**
> InlineResponse2012 MeasTaSubscriptionsPOST(ctx, measTaSubscriptionPost)


Creates a subscription to UE Timing Advance notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **measTaSubscriptionPost** | [**MeasTaSubscriptionPost1**](MeasTaSubscriptionPost1.md)| Use to creates a subscription to UE Timing Advance notifications based on the filter criteria | 

### Return type

[**InlineResponse2012**](inline_response_201_2.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasTaSubscriptionsPUT**
> MeasTaSubscription1 MeasTaSubscriptionsPUT(ctx, subscriptionId, measTaSubscription)


Updates a subscription to UE Timing Advance notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **measTaSubscription** | [**MeasTaSubscription1**](MeasTaSubscription1.md)| Use to creates a subscription to UE Timing Advance notifications based on the filter criteria | 

### Return type

[**MeasTaSubscription1**](MeasTaSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **MeasTaSubscriptionsSubscrIdDELETE**
> MeasTaSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **PlmnInfoGET**
> InlineResponse2001 PlmnInfoGET(ctx, appInsId)


Gets the information on Mobile Network(s) that are associated with a specific mobile edge application instance

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **appInsId** | [**[]string**](string.md)| Application instance identifier | 

### Return type

[**InlineResponse2001**](inline_response_200_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabEstSubscriptionSubscriptionsGET**
> InlineResponse2007 RabEstSubscriptionSubscriptionsGET(ctx, subscriptionId)


Gets a subscription to RAB establishment notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2007**](inline_response_200_7.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabEstSubscriptionSubscriptionsPOST**
> InlineResponse2014 RabEstSubscriptionSubscriptionsPOST(ctx, rabEstSubscriptionPost)


Creates a subscription to RAB establishment notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **rabEstSubscriptionPost** | [**RabEstSubscriptionPost1**](RabEstSubscriptionPost1.md)| Use to creates a subscription to RAB establishment notifications based on the filter criteria | 

### Return type

[**InlineResponse2014**](inline_response_201_4.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabEstSubscriptionSubscriptionsPUT**
> RabEstSubscription1 RabEstSubscriptionSubscriptionsPUT(ctx, subscriptionId, rabEstSubscription)


Updates a subscription to RAB establishment notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **rabEstSubscription** | [**RabEstSubscription1**](RabEstSubscription1.md)| Use to creates a subscription to RAB establishment notifications based on the filter criteria | 

### Return type

[**RabEstSubscription1**](RabEstSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabEstSubscriptionsSubscrIdDELETE**
> RabEstSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabInfoGET**
> InlineResponse200 RabInfoGET(ctx, optional)


Gets information on existing E-RABs that are associated with a specific mobile edge application instance

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
 **optional** | ***RabInfoGETOpts** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a pointer to a RabInfoGETOpts struct

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appInsId** | **optional.String**| Application instance identifier | 
 **cellId** | [**optional.Interface of []string**](string.md)| E-UTRAN Cell Identity as a bit string (size (28)), as defined in ETSI TS 136 413 | 
 **ueIpv4Address** | [**optional.Interface of []string**](string.md)| Comma separated list of IE IPv4 addresses as defined for the type for AssociateId | 
 **ueIpv6Address** | [**optional.Interface of []string**](string.md)| Comma separated list of IE IPv6 addresses as defined for the type for AssociateId | 
 **natedIpAddress** | [**optional.Interface of []string**](string.md)| Comma separated list of IE NATed IP addresses as defined for the type for AssociateId | 
 **gtpTeid** | [**optional.Interface of []string**](string.md)| Comma separated list of GTP TEID addresses as defined for the type for AssociateId | 
 **erabId** | **optional.Int32**| E-RAB identifier | 
 **qci** | **optional.Int32**| QoS Class Identifier as defined in ETSI TS 123 401 | 
 **erabMbrDl** | **optional.Int32**| Maximum downlink E-RAB Bit Rate as defined in ETSI TS 123 401 | 
 **erabMbrUl** | **optional.Int32**| Maximum uplink E-RAB Bit Rate as defined in ETSI TS 123 401 | 
 **erabGbrDl** | **optional.Int32**| Guaranteed downlink E-RAB Bit Rate as defined in ETSI TS 123 401 | 
 **erabGbrUl** | **optional.Int32**| Guaranteed uplink E-RAB Bit Rate as defined in ETSI TS 123 401 | 

### Return type

[**InlineResponse200**](inline_response_200.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabModSubscriptionSubscriptionsGET**
> InlineResponse2008 RabModSubscriptionSubscriptionsGET(ctx, subscriptionId)


Gets a subscription to RAB Modification notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2008**](inline_response_200_8.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabModSubscriptionSubscriptionsPOST**
> InlineResponse2015 RabModSubscriptionSubscriptionsPOST(ctx, rabModSubscriptionPost)


Creates a subscription to RAB Modification notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **rabModSubscriptionPost** | [**RabModSubscriptionPost1**](RabModSubscriptionPost1.md)| Use to creates a subscription to RAB Modification notifications based on the filter criteria | 

### Return type

[**InlineResponse2015**](inline_response_201_5.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabModSubscriptionSubscriptionsPUT**
> RabModSubscription1 RabModSubscriptionSubscriptionsPUT(ctx, subscriptionId, rabModSubscription)


Updates a subscription to RAB Modification notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **rabModSubscription** | [**RabModSubscription1**](RabModSubscription1.md)| Use to creates a subscription to RAB Modification notifications based on the filter criteria | 

### Return type

[**RabModSubscription1**](RabModSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabModSubscriptionsSubscrIdDELETE**
> RabModSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabRelSubscriptionSubscriptionsGET**
> InlineResponse2009 RabRelSubscriptionSubscriptionsGET(ctx, subscriptionId)


Gets a subscription to RAB Release notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2009**](inline_response_200_9.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabRelSubscriptionSubscriptionsPOST**
> InlineResponse2016 RabRelSubscriptionSubscriptionsPOST(ctx, rabRelSubscriptionPost)


Creates a subscription to RAB Release notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **rabRelSubscriptionPost** | [**RabRelSubscriptionPost1**](RabRelSubscriptionPost1.md)| Use to creates a subscription to RAB Release notifications based on the filter criteria | 

### Return type

[**InlineResponse2016**](inline_response_201_6.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabRelSubscriptionSubscriptionsPUT**
> RabRelSubscription1 RabRelSubscriptionSubscriptionsPUT(ctx, subscriptionId, rabRelSubscription)


Updates a subscription to RAB Release notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **rabRelSubscription** | [**RabRelSubscription1**](RabRelSubscription1.md)| Use to creates a subscription to RAB Release notifications based on the filter criteria | 

### Return type

[**RabRelSubscription1**](RabRelSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **RabRelSubscriptionsSubscrIdDELETE**
> RabRelSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **S1BearerInfoGET**
> InlineResponse2002 S1BearerInfoGET(ctx, optional)


Gets information on existing E-RABs that are associated with a specific mobile edge application instance

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
 **optional** | ***S1BearerInfoGETOpts** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a pointer to a S1BearerInfoGETOpts struct

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tempUeId** | [**optional.Interface of []string**](string.md)| The temporary identifier allocated for the specific UE as defined in ETSI TS 136 413 | 
 **ueIpv4Address** | [**optional.Interface of []string**](string.md)| Comma separated list of IE IPv4 addresses as defined for the type for AssociateId | 
 **ueIpv6Address** | [**optional.Interface of []string**](string.md)| Comma separated list of IE IPv6 addresses as defined for the type for AssociateId | 
 **natedIpAddress** | [**optional.Interface of []string**](string.md)| Comma separated list of IE NATed IP addresses as defined for the type for AssociateId | 
 **gtpTeid** | [**optional.Interface of []string**](string.md)| Comma separated list of GTP TEID addresses as defined for the type for AssociateId | 
 **cellId** | [**optional.Interface of []string**](string.md)| E-UTRAN Cell Identity as a bit string (size (28)), as defined in ETSI TS 136 413 | 
 **erabId** | [**optional.Interface of []int32**](int32.md)| E-RAB identifier | 

### Return type

[**InlineResponse2002**](inline_response_200_2.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **S1BearerSubscriptionSubscriptionsGET**
> InlineResponse2011 S1BearerSubscriptionSubscriptionsGET(ctx, subscriptionId)


Gets a subscription to S1 bearer notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

[**InlineResponse2011**](inline_response_201_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **S1BearerSubscriptionSubscriptionsPOST**
> InlineResponse2011 S1BearerSubscriptionSubscriptionsPOST(ctx, s1BearerSubscriptionPost)


Creates a subscription to S1 bearer notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **s1BearerSubscriptionPost** | [**S1BearerSubscriptionPost1**](S1BearerSubscriptionPost1.md)| Use to creates a subscription to S1 Bearer notifications based on the filter criteria | 

### Return type

[**InlineResponse2011**](inline_response_201_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **S1BearerSubscriptionSubscriptionsPUT**
> S1BearerSubscription1 S1BearerSubscriptionSubscriptionsPUT(ctx, subscriptionId, s1BearerSubscription)


Updates a subscription to S1 bearer notifications from Radio Network Information Service

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 
  **s1BearerSubscription** | [**S1BearerSubscription1**](S1BearerSubscription1.md)| Use to creates a subscription to S1 Bearer notifications based on the filter criteria | 

### Return type

[**S1BearerSubscription1**](S1BearerSubscription_1.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **S1BearerSubscriptionsSubscrIdDELETE**
> S1BearerSubscriptionsSubscrIdDELETE(ctx, subscriptionId)


Method to delete a subscription

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context for authentication, logging, cancellation, deadlines, tracing, etc.
  **subscriptionId** | **string**| Subscription Id, specifically the \&quot;self\&quot; returned in the subscription request | 

### Return type

 (empty response body)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsCcGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsCcGET(ctx, )


The GET method can be used to request information about the cell_change subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsCrGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsCrGET(ctx, )


The GET method can be used to request information about the ca_reconf subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsGET(ctx, )


The GET method can be used to request information about the subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsMrGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsMrGET(ctx, )


The GET method can be used to request information about the meas_rep_ue subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsReGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsReGET(ctx, )


The GET method can be used to request information about the rab_est subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsRmGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsRmGET(ctx, )


The GET method can be used to request information about the rab_mod subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsRrGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsRrGET(ctx, )


The GET method can be used to request information about the rab_rel subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsS1GET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsS1GET(ctx, )


The GET method can be used to request information about the s1_bearer subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **SubscriptionLinkListSubscriptionsTaGET**
> InlineResponse2003 SubscriptionLinkListSubscriptionsTaGET(ctx, )


The GET method can be used to request information about the ta subscriptions for this requestor

### Required Parameters
This endpoint does not need any parameter.

### Return type

[**InlineResponse2003**](inline_response_200_3.md)

### Authorization

[OauthSecurity](../README.md#OauthSecurity)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/problem+json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

