# Go API client for client

Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/01.01.01_60/gs_MEC012v010101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rni/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**CaReConfSubscriptionSubscriptionsGET**](docs/DefaultApi.md#careconfsubscriptionsubscriptionsget) | **Get** /subscriptions/ca_reconf/{subscriptionId} | 
*DefaultApi* | [**CaReConfSubscriptionSubscriptionsPOST**](docs/DefaultApi.md#careconfsubscriptionsubscriptionspost) | **Post** /subscriptions/ca_reconf | 
*DefaultApi* | [**CaReConfSubscriptionSubscriptionsPUT**](docs/DefaultApi.md#careconfsubscriptionsubscriptionsput) | **Put** /subscriptions/ca_reconf/{subscriptionId} | 
*DefaultApi* | [**CaReConfSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#careconfsubscriptionssubscriddelete) | **Delete** /subscriptions/ca_reconf/{subscriptionId} | 
*DefaultApi* | [**CellChangeSubscriptionsGET**](docs/DefaultApi.md#cellchangesubscriptionsget) | **Get** /subscriptions/cell_change/{subscriptionId} | 
*DefaultApi* | [**CellChangeSubscriptionsPOST**](docs/DefaultApi.md#cellchangesubscriptionspost) | **Post** /subscriptions/cell_change | 
*DefaultApi* | [**CellChangeSubscriptionsPUT**](docs/DefaultApi.md#cellchangesubscriptionsput) | **Put** /subscriptions/cell_change/{subscriptionId} | 
*DefaultApi* | [**CellChangeSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#cellchangesubscriptionssubscriddelete) | **Delete** /subscriptions/cell_change/{subscriptionId} | 
*DefaultApi* | [**MeasRepUeReportSubscriptionsPUT**](docs/DefaultApi.md#measrepuereportsubscriptionsput) | **Put** /subscriptions/meas_rep_ue/{subscriptionId} | 
*DefaultApi* | [**MeasRepUeSubscriptionsGET**](docs/DefaultApi.md#measrepuesubscriptionsget) | **Get** /subscriptions/meas_rep_ue/{subscriptionId} | 
*DefaultApi* | [**MeasRepUeSubscriptionsPOST**](docs/DefaultApi.md#measrepuesubscriptionspost) | **Post** /subscriptions/meas_rep_ue | 
*DefaultApi* | [**MeasRepUeSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#measrepuesubscriptionssubscriddelete) | **Delete** /subscriptions/meas_rep_ue/{subscriptionId} | 
*DefaultApi* | [**MeasTaSubscriptionsGET**](docs/DefaultApi.md#meastasubscriptionsget) | **Get** /subscriptions/ta/{subscriptionId} | 
*DefaultApi* | [**MeasTaSubscriptionsPOST**](docs/DefaultApi.md#meastasubscriptionspost) | **Post** /subscriptions/ta | 
*DefaultApi* | [**MeasTaSubscriptionsPUT**](docs/DefaultApi.md#meastasubscriptionsput) | **Put** /subscriptions/ta/{subscriptionId} | 
*DefaultApi* | [**MeasTaSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#meastasubscriptionssubscriddelete) | **Delete** /subscriptions/ta/{subscriptionId} | 
*DefaultApi* | [**PlmnInfoGET**](docs/DefaultApi.md#plmninfoget) | **Get** /queries/plmn_info | 
*DefaultApi* | [**RabEstSubscriptionSubscriptionsGET**](docs/DefaultApi.md#rabestsubscriptionsubscriptionsget) | **Get** /subscriptions/rab_est/{subscriptionId} | 
*DefaultApi* | [**RabEstSubscriptionSubscriptionsPOST**](docs/DefaultApi.md#rabestsubscriptionsubscriptionspost) | **Post** /subscriptions/rab_est | 
*DefaultApi* | [**RabEstSubscriptionSubscriptionsPUT**](docs/DefaultApi.md#rabestsubscriptionsubscriptionsput) | **Put** /subscriptions/rab_est/{subscriptionId} | 
*DefaultApi* | [**RabEstSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#rabestsubscriptionssubscriddelete) | **Delete** /subscriptions/rab_est/{subscriptionId} | 
*DefaultApi* | [**RabInfoGET**](docs/DefaultApi.md#rabinfoget) | **Get** /queries/rab_info | 
*DefaultApi* | [**RabModSubscriptionSubscriptionsGET**](docs/DefaultApi.md#rabmodsubscriptionsubscriptionsget) | **Get** /subscriptions/rab_mod/{subscriptionId} | 
*DefaultApi* | [**RabModSubscriptionSubscriptionsPOST**](docs/DefaultApi.md#rabmodsubscriptionsubscriptionspost) | **Post** /subscriptions/rab_mod | 
*DefaultApi* | [**RabModSubscriptionSubscriptionsPUT**](docs/DefaultApi.md#rabmodsubscriptionsubscriptionsput) | **Put** /subscriptions/rab_mod/{subscriptionId} | 
*DefaultApi* | [**RabModSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#rabmodsubscriptionssubscriddelete) | **Delete** /subscriptions/rab_mod/{subscriptionId} | 
*DefaultApi* | [**RabRelSubscriptionSubscriptionsGET**](docs/DefaultApi.md#rabrelsubscriptionsubscriptionsget) | **Get** /subscriptions/rab_rel/{subscriptionId} | 
*DefaultApi* | [**RabRelSubscriptionSubscriptionsPOST**](docs/DefaultApi.md#rabrelsubscriptionsubscriptionspost) | **Post** /subscriptions/rab_rel | 
*DefaultApi* | [**RabRelSubscriptionSubscriptionsPUT**](docs/DefaultApi.md#rabrelsubscriptionsubscriptionsput) | **Put** /subscriptions/rab_rel/{subscriptionId} | 
*DefaultApi* | [**RabRelSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#rabrelsubscriptionssubscriddelete) | **Delete** /subscriptions/rab_rel/{subscriptionId} | 
*DefaultApi* | [**S1BearerInfoGET**](docs/DefaultApi.md#s1bearerinfoget) | **Get** /queries/s1_bearer_info | 
*DefaultApi* | [**S1BearerSubscriptionSubscriptionsGET**](docs/DefaultApi.md#s1bearersubscriptionsubscriptionsget) | **Get** /subscriptions/s1_bearer/{subscriptionId} | 
*DefaultApi* | [**S1BearerSubscriptionSubscriptionsPOST**](docs/DefaultApi.md#s1bearersubscriptionsubscriptionspost) | **Post** /subscriptions/s1_bearer | 
*DefaultApi* | [**S1BearerSubscriptionSubscriptionsPUT**](docs/DefaultApi.md#s1bearersubscriptionsubscriptionsput) | **Put** /subscriptions/s1_bearer/{subscriptionId} | 
*DefaultApi* | [**S1BearerSubscriptionsSubscrIdDELETE**](docs/DefaultApi.md#s1bearersubscriptionssubscriddelete) | **Delete** /subscriptions/s1_bearer/{subscriptionId} | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsCcGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionsccget) | **Get** /subscriptions/cell_change | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsCrGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionscrget) | **Get** /subscriptions/ca_reconf | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionsget) | **Get** /subscriptions/ | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsMrGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionsmrget) | **Get** /subscriptions/meas_rep_ue | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsReGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionsreget) | **Get** /subscriptions/rab_est | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsRmGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionsrmget) | **Get** /subscriptions/rab_mod | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsRrGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionsrrget) | **Get** /subscriptions/rab_rel | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsS1GET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionss1get) | **Get** /subscriptions/s1_bearer | 
*DefaultApi* | [**SubscriptionLinkListSubscriptionsTaGET**](docs/DefaultApi.md#subscriptionlinklistsubscriptionstaget) | **Get** /subscriptions/ta | 


## Documentation For Models

 - [AssociateId](docs/AssociateId.md)
 - [CaReConfSubscription](docs/CaReConfSubscription.md)
 - [CaReConfSubscription1](docs/CaReConfSubscription1.md)
 - [CaReConfSubscriptionPost](docs/CaReConfSubscriptionPost.md)
 - [CaReConfSubscriptionPost1](docs/CaReConfSubscriptionPost1.md)
 - [CellChangeSubscription](docs/CellChangeSubscription.md)
 - [CellChangeSubscription1](docs/CellChangeSubscription1.md)
 - [CellChangeSubscriptionPost](docs/CellChangeSubscriptionPost.md)
 - [CellChangeSubscriptionPost1](docs/CellChangeSubscriptionPost1.md)
 - [CellUserInfo](docs/CellUserInfo.md)
 - [Ecgi](docs/Ecgi.md)
 - [ErabQosParameters](docs/ErabQosParameters.md)
 - [ErabQosParametersQci](docs/ErabQosParametersQci.md)
 - [EventType](docs/EventType.md)
 - [FilterCriteriaAssoc](docs/FilterCriteriaAssoc.md)
 - [FilterCriteriaAssocHo](docs/FilterCriteriaAssocHo.md)
 - [FilterCriteriaAssocQci](docs/FilterCriteriaAssocQci.md)
 - [FilterCriteriaAssocTri](docs/FilterCriteriaAssocTri.md)
 - [HoStatus](docs/HoStatus.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse201](docs/InlineResponse201.md)
 - [InlineResponse2011](docs/InlineResponse2011.md)
 - [InlineResponse2012](docs/InlineResponse2012.md)
 - [InlineResponse2013](docs/InlineResponse2013.md)
 - [InlineResponse2014](docs/InlineResponse2014.md)
 - [InlineResponse2015](docs/InlineResponse2015.md)
 - [InlineResponse2016](docs/InlineResponse2016.md)
 - [InlineResponse2017](docs/InlineResponse2017.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse403](docs/InlineResponse403.md)
 - [Link](docs/Link.md)
 - [MeasRepUeSubscription](docs/MeasRepUeSubscription.md)
 - [MeasRepUeSubscription1](docs/MeasRepUeSubscription1.md)
 - [MeasRepUeSubscriptionPost](docs/MeasRepUeSubscriptionPost.md)
 - [MeasRepUeSubscriptionPost1](docs/MeasRepUeSubscriptionPost1.md)
 - [MeasTaSubscription](docs/MeasTaSubscription.md)
 - [MeasTaSubscription1](docs/MeasTaSubscription1.md)
 - [MeasTaSubscriptionPost](docs/MeasTaSubscriptionPost.md)
 - [MeasTaSubscriptionPost1](docs/MeasTaSubscriptionPost1.md)
 - [Plmn](docs/Plmn.md)
 - [PlmnInfo](docs/PlmnInfo.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [QosInformation](docs/QosInformation.md)
 - [RabEstSubscription](docs/RabEstSubscription.md)
 - [RabEstSubscription1](docs/RabEstSubscription1.md)
 - [RabEstSubscriptionPost](docs/RabEstSubscriptionPost.md)
 - [RabEstSubscriptionPost1](docs/RabEstSubscriptionPost1.md)
 - [RabInfo](docs/RabInfo.md)
 - [RabModSubscription](docs/RabModSubscription.md)
 - [RabModSubscription1](docs/RabModSubscription1.md)
 - [RabModSubscriptionPost](docs/RabModSubscriptionPost.md)
 - [RabModSubscriptionPost1](docs/RabModSubscriptionPost1.md)
 - [RabRelSubscription](docs/RabRelSubscription.md)
 - [RabRelSubscription1](docs/RabRelSubscription1.md)
 - [RabRelSubscriptionPost](docs/RabRelSubscriptionPost.md)
 - [RabRelSubscriptionPost1](docs/RabRelSubscriptionPost1.md)
 - [S1BearerInfo](docs/S1BearerInfo.md)
 - [S1BearerInfoDetailed](docs/S1BearerInfoDetailed.md)
 - [S1BearerSubscription](docs/S1BearerSubscription.md)
 - [S1BearerSubscription1](docs/S1BearerSubscription1.md)
 - [S1BearerSubscriptionCriteria](docs/S1BearerSubscriptionCriteria.md)
 - [S1BearerSubscriptionPost](docs/S1BearerSubscriptionPost.md)
 - [S1BearerSubscriptionPost1](docs/S1BearerSubscriptionPost1.md)
 - [S1EnbInfo](docs/S1EnbInfo.md)
 - [S1UeInfo](docs/S1UeInfo.md)
 - [SGwInfo](docs/SGwInfo.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionType](docs/SubscriptionType.md)
 - [TempUeId](docs/TempUeId.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [Trigger](docs/Trigger.md)
 - [UeInfo](docs/UeInfo.md)


## Documentation For Authorization

## OauthSecurity
- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **all**: Single oauth2 scope for API

Example
```golang
auth := context.WithValue(context.Background(), sw.ContextAccessToken, "ACCESSTOKENSTRING")
r, err := client.Service.Operation(auth, args)
```

Or via OAuth2 module to automatically refresh tokens and perform user authentication.
```golang
import "golang.org/x/oauth2"

/* Perform OAuth2 round trip request and obtain a token */

tokenSource := oauth2cfg.TokenSource(createContext(httpClient), &token)
auth := context.WithValue(oauth2.NoContext, sw.ContextOAuth2, tokenSource)
r, err := client.Service.Operation(auth, args)
```

## Author



