# Go API client for client

Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/01.01.01_60/gs_mec013v010101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/location/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SubscriptionsApi* | [**UserTrackingSubDelById**](docs/SubscriptionsApi.md#usertrackingsubdelbyid) | **Delete** /subscriptions/userTracking/{subscriptionId} | 
*SubscriptionsApi* | [**UserTrackingSubGet**](docs/SubscriptionsApi.md#usertrackingsubget) | **Get** /subscriptions/userTracking | 
*SubscriptionsApi* | [**UserTrackingSubGetById**](docs/SubscriptionsApi.md#usertrackingsubgetbyid) | **Get** /subscriptions/userTracking/{subscriptionId} | 
*SubscriptionsApi* | [**UserTrackingSubPost**](docs/SubscriptionsApi.md#usertrackingsubpost) | **Post** /subscriptions/userTracking | 
*SubscriptionsApi* | [**UserTrackingSubPutById**](docs/SubscriptionsApi.md#usertrackingsubputbyid) | **Put** /subscriptions/userTracking/{subscriptionId} | 
*SubscriptionsApi* | [**ZonalTrafficSubDelById**](docs/SubscriptionsApi.md#zonaltrafficsubdelbyid) | **Delete** /subscriptions/zonalTraffic/{subscriptionId} | 
*SubscriptionsApi* | [**ZonalTrafficSubGet**](docs/SubscriptionsApi.md#zonaltrafficsubget) | **Get** /subscriptions/zonalTraffic | 
*SubscriptionsApi* | [**ZonalTrafficSubGetById**](docs/SubscriptionsApi.md#zonaltrafficsubgetbyid) | **Get** /subscriptions/zonalTraffic/{subscriptionId} | 
*SubscriptionsApi* | [**ZonalTrafficSubPost**](docs/SubscriptionsApi.md#zonaltrafficsubpost) | **Post** /subscriptions/zonalTraffic | 
*SubscriptionsApi* | [**ZonalTrafficSubPutById**](docs/SubscriptionsApi.md#zonaltrafficsubputbyid) | **Put** /subscriptions/zonalTraffic/{subscriptionId} | 
*SubscriptionsApi* | [**ZoneStatusDelById**](docs/SubscriptionsApi.md#zonestatusdelbyid) | **Delete** /subscriptions/zoneStatus/{subscriptionId} | 
*SubscriptionsApi* | [**ZoneStatusGet**](docs/SubscriptionsApi.md#zonestatusget) | **Get** /subscriptions/zonalStatus | 
*SubscriptionsApi* | [**ZoneStatusGetById**](docs/SubscriptionsApi.md#zonestatusgetbyid) | **Get** /subscriptions/zoneStatus/{subscriptionId} | 
*SubscriptionsApi* | [**ZoneStatusPost**](docs/SubscriptionsApi.md#zonestatuspost) | **Post** /subscriptions/zonalStatus | 
*SubscriptionsApi* | [**ZoneStatusPutById**](docs/SubscriptionsApi.md#zonestatusputbyid) | **Put** /subscriptions/zoneStatus/{subscriptionId} | 
*UsersApi* | [**UsersGet**](docs/UsersApi.md#usersget) | **Get** /users | 
*UsersApi* | [**UsersGetById**](docs/UsersApi.md#usersgetbyid) | **Get** /users/{userId} | 
*ZonesApi* | [**ZonesByIdGetAps**](docs/ZonesApi.md#zonesbyidgetaps) | **Get** /zones/{zoneId}/accessPoints | 
*ZonesApi* | [**ZonesByIdGetApsById**](docs/ZonesApi.md#zonesbyidgetapsbyid) | **Get** /zones/{zoneId}/accessPoints/{accessPointId} | 
*ZonesApi* | [**ZonesGet**](docs/ZonesApi.md#zonesget) | **Get** /zones | 
*ZonesApi* | [**ZonesGetById**](docs/ZonesApi.md#zonesgetbyid) | **Get** /zones/{zoneId} | 


## Documentation For Models

 - [AccessPointInfo](docs/AccessPointInfo.md)
 - [AccessPointList](docs/AccessPointList.md)
 - [ConnectionType](docs/ConnectionType.md)
 - [Link](docs/Link.md)
 - [LocationInfo](docs/LocationInfo.md)
 - [OperationStatus](docs/OperationStatus.md)
 - [ResponseAccessPointInfo](docs/ResponseAccessPointInfo.md)
 - [ResponseAccessPointList](docs/ResponseAccessPointList.md)
 - [ResponseUserInfo](docs/ResponseUserInfo.md)
 - [ResponseUserList](docs/ResponseUserList.md)
 - [ResponseUserTrackingNotificationSubscriptionList](docs/ResponseUserTrackingNotificationSubscriptionList.md)
 - [ResponseUserTrackingSubscription](docs/ResponseUserTrackingSubscription.md)
 - [ResponseZonalTrafficNotificationSubscriptionList](docs/ResponseZonalTrafficNotificationSubscriptionList.md)
 - [ResponseZonalTrafficSubscription](docs/ResponseZonalTrafficSubscription.md)
 - [ResponseZoneInfo](docs/ResponseZoneInfo.md)
 - [ResponseZoneList](docs/ResponseZoneList.md)
 - [ResponseZoneStatusNotificationSubscriptionList](docs/ResponseZoneStatusNotificationSubscriptionList.md)
 - [ResponseZoneStatusSubscription](docs/ResponseZoneStatusSubscription.md)
 - [ResponseZoneStatusSubscription2](docs/ResponseZoneStatusSubscription2.md)
 - [UserEventType](docs/UserEventType.md)
 - [UserInfo](docs/UserInfo.md)
 - [UserList](docs/UserList.md)
 - [UserTrackingNotificationSubscriptionList](docs/UserTrackingNotificationSubscriptionList.md)
 - [UserTrackingSubscription](docs/UserTrackingSubscription.md)
 - [UserTrackingSubscriptionCallbackReference](docs/UserTrackingSubscriptionCallbackReference.md)
 - [ZonalPresenceNotification](docs/ZonalPresenceNotification.md)
 - [ZonalTrafficNotificationSubscriptionList](docs/ZonalTrafficNotificationSubscriptionList.md)
 - [ZonalTrafficSubscription](docs/ZonalTrafficSubscription.md)
 - [ZoneInfo](docs/ZoneInfo.md)
 - [ZoneList](docs/ZoneList.md)
 - [ZoneStatusNotification](docs/ZoneStatusNotification.md)
 - [ZoneStatusNotificationSubscriptionList](docs/ZoneStatusNotificationSubscriptionList.md)
 - [ZoneStatusSubscription](docs/ZoneStatusSubscription.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

