/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Radio Network Information Service REST API
 *
 * Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/01.01.01_60/gs_MEC012v010101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.1.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		var handler http.Handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = httpLog.LogRx(handler, "")

		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/rni/v1/",
		Index,
	},

	Route{
		"CaReConfSubscriptionSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/ca_reconf/{subscriptionId}",
		CaReConfSubscriptionSubscriptionsGET,
	},

	Route{
		"CaReConfSubscriptionSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/ca_reconf",
		CaReConfSubscriptionSubscriptionsPOST,
	},

	Route{
		"CaReConfSubscriptionSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/ca_reconf/{subscriptionId}",
		CaReConfSubscriptionSubscriptionsPUT,
	},

	Route{
		"CaReConfSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/ca_reconf/{subscriptionId}",
		CaReConfSubscriptionsSubscrIdDELETE,
	},

	Route{
		"CellChangeSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/cell_change/{subscriptionId}",
		CellChangeSubscriptionsGET,
	},

	Route{
		"CellChangeSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/cell_change",
		CellChangeSubscriptionsPOST,
	},

	Route{
		"CellChangeSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/cell_change/{subscriptionId}",
		CellChangeSubscriptionsPUT,
	},

	Route{
		"CellChangeSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/cell_change/{subscriptionId}",
		CellChangeSubscriptionsSubscrIdDELETE,
	},

	Route{
		"MeasRepUeReportSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/meas_rep_ue/{subscriptionId}",
		MeasRepUeReportSubscriptionsPUT,
	},

	Route{
		"MeasRepUeSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/meas_rep_ue/{subscriptionId}",
		MeasRepUeSubscriptionsGET,
	},

	Route{
		"MeasRepUeSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/meas_rep_ue",
		MeasRepUeSubscriptionsPOST,
	},

	Route{
		"MeasRepUeSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/meas_rep_ue/{subscriptionId}",
		MeasRepUeSubscriptionsSubscrIdDELETE,
	},

	Route{
		"MeasTaSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/ta/{subscriptionId}",
		MeasTaSubscriptionsGET,
	},

	Route{
		"MeasTaSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/ta",
		MeasTaSubscriptionsPOST,
	},

	Route{
		"MeasTaSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/ta/{subscriptionId}",
		MeasTaSubscriptionsPUT,
	},

	Route{
		"MeasTaSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/ta/{subscriptionId}",
		MeasTaSubscriptionsSubscrIdDELETE,
	},

	Route{
		"PlmnInfoGET",
		strings.ToUpper("Get"),
		"/rni/v1/queries/plmn_info",
		PlmnInfoGET,
	},

	Route{
		"RabEstSubscriptionSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/rab_est/{subscriptionId}",
		RabEstSubscriptionSubscriptionsGET,
	},

	Route{
		"RabEstSubscriptionSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/rab_est",
		RabEstSubscriptionSubscriptionsPOST,
	},

	Route{
		"RabEstSubscriptionSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/rab_est/{subscriptionId}",
		RabEstSubscriptionSubscriptionsPUT,
	},

	Route{
		"RabEstSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/rab_est/{subscriptionId}",
		RabEstSubscriptionsSubscrIdDELETE,
	},

	Route{
		"RabInfoGET",
		strings.ToUpper("Get"),
		"/rni/v1/queries/rab_info",
		RabInfoGET,
	},

	Route{
		"RabModSubscriptionSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/rab_mod/{subscriptionId}",
		RabModSubscriptionSubscriptionsGET,
	},

	Route{
		"RabModSubscriptionSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/rab_mod",
		RabModSubscriptionSubscriptionsPOST,
	},

	Route{
		"RabModSubscriptionSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/rab_mod/{subscriptionId}",
		RabModSubscriptionSubscriptionsPUT,
	},

	Route{
		"RabModSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/rab_mod/{subscriptionId}",
		RabModSubscriptionsSubscrIdDELETE,
	},

	Route{
		"RabRelSubscriptionSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/rab_rel/{subscriptionId}",
		RabRelSubscriptionSubscriptionsGET,
	},

	Route{
		"RabRelSubscriptionSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/rab_rel",
		RabRelSubscriptionSubscriptionsPOST,
	},

	Route{
		"RabRelSubscriptionSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/rab_rel/{subscriptionId}",
		RabRelSubscriptionSubscriptionsPUT,
	},

	Route{
		"RabRelSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/rab_rel/{subscriptionId}",
		RabRelSubscriptionsSubscrIdDELETE,
	},

	Route{
		"S1BearerInfoGET",
		strings.ToUpper("Get"),
		"/rni/v1/queries/s1_bearer_info",
		S1BearerInfoGET,
	},

	Route{
		"S1BearerSubscriptionSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/s1_bearer/{subscriptionId}",
		S1BearerSubscriptionSubscriptionsGET,
	},

	Route{
		"S1BearerSubscriptionSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/rni/v1/subscriptions/s1_bearer",
		S1BearerSubscriptionSubscriptionsPOST,
	},

	Route{
		"S1BearerSubscriptionSubscriptionsPUT",
		strings.ToUpper("Put"),
		"/rni/v1/subscriptions/s1_bearer/{subscriptionId}",
		S1BearerSubscriptionSubscriptionsPUT,
	},

	Route{
		"S1BearerSubscriptionsSubscrIdDELETE",
		strings.ToUpper("Delete"),
		"/rni/v1/subscriptions/s1_bearer/{subscriptionId}",
		S1BearerSubscriptionsSubscrIdDELETE,
	},

	Route{
		"SubscriptionLinkListSubscriptionsCcGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/cell_change",
		SubscriptionLinkListSubscriptionsCcGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsCrGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/ca_reconf",
		SubscriptionLinkListSubscriptionsCrGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/",
		SubscriptionLinkListSubscriptionsGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsMrGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/meas_rep_ue",
		SubscriptionLinkListSubscriptionsMrGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsReGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/rab_est",
		SubscriptionLinkListSubscriptionsReGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsRmGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/rab_mod",
		SubscriptionLinkListSubscriptionsRmGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsRrGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/rab_rel",
		SubscriptionLinkListSubscriptionsRrGET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsS1GET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/s1_bearer",
		SubscriptionLinkListSubscriptionsS1GET,
	},

	Route{
		"SubscriptionLinkListSubscriptionsTaGET",
		strings.ToUpper("Get"),
		"/rni/v1/subscriptions/ta",
		SubscriptionLinkListSubscriptionsTaGET,
	},
}
