/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Location Service REST API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/01.01.01_60/gs_mec013v010101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		var handler http.Handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = httpLog.LogRx(handler, "")

		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/location/v1/",
		Index,
	},

	Route{
		"UserTrackingSubDelById",
		strings.ToUpper("Delete"),
		"/location/v1/subscriptions/userTracking/{subscriptionId}",
		UserTrackingSubDelById,
	},

	Route{
		"UserTrackingSubGet",
		strings.ToUpper("Get"),
		"/location/v1/subscriptions/userTracking",
		UserTrackingSubGet,
	},

	Route{
		"UserTrackingSubGetById",
		strings.ToUpper("Get"),
		"/location/v1/subscriptions/userTracking/{subscriptionId}",
		UserTrackingSubGetById,
	},

	Route{
		"UserTrackingSubPost",
		strings.ToUpper("Post"),
		"/location/v1/subscriptions/userTracking",
		UserTrackingSubPost,
	},

	Route{
		"UserTrackingSubPutById",
		strings.ToUpper("Put"),
		"/location/v1/subscriptions/userTracking/{subscriptionId}",
		UserTrackingSubPutById,
	},

	Route{
		"ZonalTrafficSubDelById",
		strings.ToUpper("Delete"),
		"/location/v1/subscriptions/zonalTraffic/{subscriptionId}",
		ZonalTrafficSubDelById,
	},

	Route{
		"ZonalTrafficSubGet",
		strings.ToUpper("Get"),
		"/location/v1/subscriptions/zonalTraffic",
		ZonalTrafficSubGet,
	},

	Route{
		"ZonalTrafficSubGetById",
		strings.ToUpper("Get"),
		"/location/v1/subscriptions/zonalTraffic/{subscriptionId}",
		ZonalTrafficSubGetById,
	},

	Route{
		"ZonalTrafficSubPost",
		strings.ToUpper("Post"),
		"/location/v1/subscriptions/zonalTraffic",
		ZonalTrafficSubPost,
	},

	Route{
		"ZonalTrafficSubPutById",
		strings.ToUpper("Put"),
		"/location/v1/subscriptions/zonalTraffic/{subscriptionId}",
		ZonalTrafficSubPutById,
	},

	Route{
		"ZoneStatusDelById",
		strings.ToUpper("Delete"),
		"/location/v1/subscriptions/zoneStatus/{subscriptionId}",
		ZoneStatusDelById,
	},

	Route{
		"ZoneStatusGet",
		strings.ToUpper("Get"),
		"/location/v1/subscriptions/zonalStatus",
		ZoneStatusGet,
	},

	Route{
		"ZoneStatusGetById",
		strings.ToUpper("Get"),
		"/location/v1/subscriptions/zoneStatus/{subscriptionId}",
		ZoneStatusGetById,
	},

	Route{
		"ZoneStatusPost",
		strings.ToUpper("Post"),
		"/location/v1/subscriptions/zonalStatus",
		ZoneStatusPost,
	},

	Route{
		"ZoneStatusPutById",
		strings.ToUpper("Put"),
		"/location/v1/subscriptions/zoneStatus/{subscriptionId}",
		ZoneStatusPutById,
	},

	Route{
		"UsersGet",
		strings.ToUpper("Get"),
		"/location/v1/users",
		UsersGet,
	},

	Route{
		"UsersGetById",
		strings.ToUpper("Get"),
		"/location/v1/users/{userId}",
		UsersGetById,
	},

	Route{
		"ZonesByIdGetAps",
		strings.ToUpper("Get"),
		"/location/v1/zones/{zoneId}/accessPoints",
		ZonesByIdGetAps,
	},

	Route{
		"ZonesByIdGetApsById",
		strings.ToUpper("Get"),
		"/location/v1/zones/{zoneId}/accessPoints/{accessPointId}",
		ZonesByIdGetApsById,
	},

	Route{
		"ZonesGet",
		strings.ToUpper("Get"),
		"/location/v1/zones",
		ZonesGet,
	},

	Route{
		"ZonesGetById",
		strings.ToUpper("Get"),
		"/location/v1/zones/{zoneId}",
		ZonesGetById,
	},
}
