/**
 * MEEP Controller REST API
 * Copyright (c) 2019  InterDigital Communications, Inc Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.PodStatus = factory(root.MeepControllerRestApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';




  /**
   * The PodStatus model module.
   * @module model/PodStatus
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>PodStatus</code>.
   * @alias module:model/PodStatus
   * @class
   */
  var exports = function() {
    var _this = this;


















  };

  /**
   * Constructs a <code>PodStatus</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/PodStatus} obj Optional instance to populate.
   * @return {module:model/PodStatus} The populated <code>PodStatus</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('namespace')) {
        obj['namespace'] = ApiClient.convertToType(data['namespace'], 'String');
      }
      if (data.hasOwnProperty('meepApp')) {
        obj['meepApp'] = ApiClient.convertToType(data['meepApp'], 'String');
      }
      if (data.hasOwnProperty('meepOrigin')) {
        obj['meepOrigin'] = ApiClient.convertToType(data['meepOrigin'], 'String');
      }
      if (data.hasOwnProperty('meepScenario')) {
        obj['meepScenario'] = ApiClient.convertToType(data['meepScenario'], 'String');
      }
      if (data.hasOwnProperty('phase')) {
        obj['phase'] = ApiClient.convertToType(data['phase'], 'String');
      }
      if (data.hasOwnProperty('podInitialized')) {
        obj['podInitialized'] = ApiClient.convertToType(data['podInitialized'], 'String');
      }
      if (data.hasOwnProperty('podReady')) {
        obj['podReady'] = ApiClient.convertToType(data['podReady'], 'String');
      }
      if (data.hasOwnProperty('podScheduled')) {
        obj['podScheduled'] = ApiClient.convertToType(data['podScheduled'], 'String');
      }
      if (data.hasOwnProperty('podUnschedulable')) {
        obj['podUnschedulable'] = ApiClient.convertToType(data['podUnschedulable'], 'String');
      }
      if (data.hasOwnProperty('podConditionError')) {
        obj['podConditionError'] = ApiClient.convertToType(data['podConditionError'], 'String');
      }
      if (data.hasOwnProperty('containerStatusesMsg')) {
        obj['containerStatusesMsg'] = ApiClient.convertToType(data['containerStatusesMsg'], 'String');
      }
      if (data.hasOwnProperty('nbOkContainers')) {
        obj['nbOkContainers'] = ApiClient.convertToType(data['nbOkContainers'], 'String');
      }
      if (data.hasOwnProperty('nbTotalContainers')) {
        obj['nbTotalContainers'] = ApiClient.convertToType(data['nbTotalContainers'], 'String');
      }
      if (data.hasOwnProperty('nbPodRestart')) {
        obj['nbPodRestart'] = ApiClient.convertToType(data['nbPodRestart'], 'String');
      }
      if (data.hasOwnProperty('logicalState')) {
        obj['logicalState'] = ApiClient.convertToType(data['logicalState'], 'String');
      }
      if (data.hasOwnProperty('startTime')) {
        obj['startTime'] = ApiClient.convertToType(data['startTime'], 'String');
      }
    }
    return obj;
  }

  /**
   * Pod name
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * Pod namespace
   * @member {String} namespace
   */
  exports.prototype['namespace'] = undefined;
  /**
   * Pod process name
   * @member {String} meepApp
   */
  exports.prototype['meepApp'] = undefined;
  /**
   * Pod origin(core, scenario)
   * @member {String} meepOrigin
   */
  exports.prototype['meepOrigin'] = undefined;
  /**
   * Pod scenario name
   * @member {String} meepScenario
   */
  exports.prototype['meepScenario'] = undefined;
  /**
   * Pod phase
   * @member {String} phase
   */
  exports.prototype['phase'] = undefined;
  /**
   * Pod initialized (true/false)
   * @member {String} podInitialized
   */
  exports.prototype['podInitialized'] = undefined;
  /**
   * Pod ready (true/false)
   * @member {String} podReady
   */
  exports.prototype['podReady'] = undefined;
  /**
   * Pod scheduled (true/false)
   * @member {String} podScheduled
   */
  exports.prototype['podScheduled'] = undefined;
  /**
   * Pod unschedulable (true/false)
   * @member {String} podUnschedulable
   */
  exports.prototype['podUnschedulable'] = undefined;
  /**
   * Pod error message
   * @member {String} podConditionError
   */
  exports.prototype['podConditionError'] = undefined;
  /**
   * Failed container error message
   * @member {String} containerStatusesMsg
   */
  exports.prototype['containerStatusesMsg'] = undefined;
  /**
   * Number of containers that are up
   * @member {String} nbOkContainers
   */
  exports.prototype['nbOkContainers'] = undefined;
  /**
   * Number of total containers in the pod
   * @member {String} nbTotalContainers
   */
  exports.prototype['nbTotalContainers'] = undefined;
  /**
   * Number of container failures leading to pod restarts
   * @member {String} nbPodRestart
   */
  exports.prototype['nbPodRestart'] = undefined;
  /**
   * State that is mapping the kubernetes api state
   * @member {String} logicalState
   */
  exports.prototype['logicalState'] = undefined;
  /**
   * Pod creation time
   * @member {String} startTime
   */
  exports.prototype['startTime'] = undefined;



  return exports;
}));


