/*
 * Location API
 *
 * The ETSI MEC ISG MEC012 Location API described using OpenAPI. The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence
 *
 * API version: 1.1.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		var handler http.Handler = route.HandlerFunc
		handler = Logger(handler, route.Name)

		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/etsi-013/location/v1/",
		Index,
	},

	Route{
		"UserTrackingSubDelById",
		strings.ToUpper("Delete"),
		"/etsi-013/location/v1/subscriptions/userTracking/{subscriptionId}",
		UserTrackingSubDelById,
	},

	Route{
		"UserTrackingSubGet",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/subscriptions/userTracking",
		UserTrackingSubGet,
	},

	Route{
		"UserTrackingSubGetById",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/subscriptions/userTracking/{subscriptionId}",
		UserTrackingSubGetById,
	},

	Route{
		"UserTrackingSubPost",
		strings.ToUpper("Post"),
		"/etsi-013/location/v1/subscriptions/userTracking",
		UserTrackingSubPost,
	},

	Route{
		"UserTrackingSubPutById",
		strings.ToUpper("Put"),
		"/etsi-013/location/v1/subscriptions/userTracking/{subscriptionId}",
		UserTrackingSubPutById,
	},

	Route{
		"ZonalTrafficSubDelById",
		strings.ToUpper("Delete"),
		"/etsi-013/location/v1/subscriptions/zonalTraffic/{subscriptionId}",
		ZonalTrafficSubDelById,
	},

	Route{
		"ZonalTrafficSubGet",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/subscriptions/zonalTraffic",
		ZonalTrafficSubGet,
	},

	Route{
		"ZonalTrafficSubGetById",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/subscriptions/zonalTraffic/{subscriptionId}",
		ZonalTrafficSubGetById,
	},

	Route{
		"ZonalTrafficSubPost",
		strings.ToUpper("Post"),
		"/etsi-013/location/v1/subscriptions/zonalTraffic",
		ZonalTrafficSubPost,
	},

	Route{
		"ZonalTrafficSubPutById",
		strings.ToUpper("Put"),
		"/etsi-013/location/v1/subscriptions/zonalTraffic/{subscriptionId}",
		ZonalTrafficSubPutById,
	},

	Route{
		"ZoneStatusDelById",
		strings.ToUpper("Delete"),
		"/etsi-013/location/v1/subscriptions/zoneStatus/{subscriptionId}",
		ZoneStatusDelById,
	},

	Route{
		"ZoneStatusGet",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/subscriptions/zonalStatus",
		ZoneStatusGet,
	},

	Route{
		"ZoneStatusGetById",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/subscriptions/zoneStatus/{subscriptionId}",
		ZoneStatusGetById,
	},

	Route{
		"ZoneStatusPost",
		strings.ToUpper("Post"),
		"/etsi-013/location/v1/subscriptions/zonalStatus",
		ZoneStatusPost,
	},

	Route{
		"ZoneStatusPutById",
		strings.ToUpper("Put"),
		"/etsi-013/location/v1/subscriptions/zoneStatus/{subscriptionId}",
		ZoneStatusPutById,
	},

	Route{
		"UsersGet",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/users",
		UsersGet,
	},

	Route{
		"UsersGetById",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/users/{userId}",
		UsersGetById,
	},

	Route{
		"ZonesByIdGetAps",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/zones/{zoneId}/accessPoints",
		ZonesByIdGetAps,
	},

	Route{
		"ZonesByIdGetApsById",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/zones/{zoneId}/accessPoints/{accessPointId}",
		ZonesByIdGetApsById,
	},

	Route{
		"ZonesGet",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/zones",
		ZonesGet,
	},

	Route{
		"ZonesGetById",
		strings.ToUpper("Get"),
		"/etsi-013/location/v1/zones/{zoneId}",
		ZonesGetById,
	},
}
