/**
 * MEEP Controller REST API
 * Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.ServicePort = factory(root.MeepControllerRestApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';




  /**
   * The ServicePort model module.
   * @module model/ServicePort
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>ServicePort</code>.
   * Service port object
   * @alias module:model/ServicePort
   * @class
   */
  var exports = function() {
    var _this = this;




  };

  /**
   * Constructs a <code>ServicePort</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ServicePort} obj Optional instance to populate.
   * @return {module:model/ServicePort} The populated <code>ServicePort</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('protocol')) {
        obj['protocol'] = ApiClient.convertToType(data['protocol'], 'String');
      }
      if (data.hasOwnProperty('port')) {
        obj['port'] = ApiClient.convertToType(data['port'], 'Number');
      }
      if (data.hasOwnProperty('externalPort')) {
        obj['externalPort'] = ApiClient.convertToType(data['externalPort'], 'Number');
      }
    }
    return obj;
  }

  /**
   * Protocol that the application is using (TCP or UDP)
   * @member {String} protocol
   */
  exports.prototype['protocol'] = undefined;
  /**
   * Port number that the service is listening on
   * @member {Number} port
   */
  exports.prototype['port'] = undefined;
  /**
   * External port number on which to expose the application (30000 - 32767)  <li>Only one application allowed per external port <li>Scenario builder must configure to prevent conflicts 
   * @member {Number} externalPort
   */
  exports.prototype['externalPort'] = undefined;



  return exports;
}));


