/**
 * MEEP Controller REST API
 * Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ServicePort'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ServicePort'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.ServiceConfig = factory(root.MeepControllerRestApi.ApiClient, root.MeepControllerRestApi.ServicePort);
  }
}(this, function(ApiClient, ServicePort) {
  'use strict';




  /**
   * The ServiceConfig model module.
   * @module model/ServiceConfig
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>ServiceConfig</code>.
   * Service object
   * @alias module:model/ServiceConfig
   * @class
   */
  var exports = function() {
    var _this = this;




  };

  /**
   * Constructs a <code>ServiceConfig</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ServiceConfig} obj Optional instance to populate.
   * @return {module:model/ServiceConfig} The populated <code>ServiceConfig</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('meSvcName')) {
        obj['meSvcName'] = ApiClient.convertToType(data['meSvcName'], 'String');
      }
      if (data.hasOwnProperty('ports')) {
        obj['ports'] = ApiClient.convertToType(data['ports'], [ServicePort]);
      }
    }
    return obj;
  }

  /**
   * Unique service name
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * Multi-Edge service name, if any
   * @member {String} meSvcName
   */
  exports.prototype['meSvcName'] = undefined;
  /**
   * @member {Array.<module:model/ServicePort>} ports
   */
  exports.prototype['ports'] = undefined;



  return exports;
}));


