/**
 * MEEP Controller REST API
 * Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Scenario'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./Scenario'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.ScenarioList = factory(root.MeepControllerRestApi.ApiClient, root.MeepControllerRestApi.Scenario);
  }
}(this, function(ApiClient, Scenario) {
  'use strict';




  /**
   * The ScenarioList model module.
   * @module model/ScenarioList
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>ScenarioList</code>.
   * Scenario list object
   * @alias module:model/ScenarioList
   * @class
   */
  var exports = function() {
    var _this = this;


  };

  /**
   * Constructs a <code>ScenarioList</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ScenarioList} obj Optional instance to populate.
   * @return {module:model/ScenarioList} The populated <code>ScenarioList</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('scenarios')) {
        obj['scenarios'] = ApiClient.convertToType(data['scenarios'], [Scenario]);
      }
    }
    return obj;
  }

  /**
   * @member {Array.<module:model/Scenario>} scenarios
   */
  exports.prototype['scenarios'] = undefined;



  return exports;
}));


