/**
 * MEEP Controller REST API
 * Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ServiceMap'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ServiceMap'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.ExternalConfig = factory(root.MeepControllerRestApi.ApiClient, root.MeepControllerRestApi.ServiceMap);
  }
}(this, function(ApiClient, ServiceMap) {
  'use strict';




  /**
   * The ExternalConfig model module.
   * @module model/ExternalConfig
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>ExternalConfig</code>.
   * External Process configuration. NOTE: Only valid if &#39;isExternal&#39; is set.
   * @alias module:model/ExternalConfig
   * @class
   */
  var exports = function() {
    var _this = this;



  };

  /**
   * Constructs a <code>ExternalConfig</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ExternalConfig} obj Optional instance to populate.
   * @return {module:model/ExternalConfig} The populated <code>ExternalConfig</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('ingressServiceMap')) {
        obj['ingressServiceMap'] = ApiClient.convertToType(data['ingressServiceMap'], [ServiceMap]);
      }
      if (data.hasOwnProperty('egressServiceMap')) {
        obj['egressServiceMap'] = ApiClient.convertToType(data['egressServiceMap'], [ServiceMap]);
      }
    }
    return obj;
  }

  /**
   * @member {Array.<module:model/ServiceMap>} ingressServiceMap
   */
  exports.prototype['ingressServiceMap'] = undefined;
  /**
   * @member {Array.<module:model/ServiceMap>} egressServiceMap
   */
  exports.prototype['egressServiceMap'] = undefined;



  return exports;
}));


