/**
 * MEEP Controller REST API
 * Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Domain'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./Domain'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.Deployment = factory(root.MeepControllerRestApi.ApiClient, root.MeepControllerRestApi.Domain);
  }
}(this, function(ApiClient, Domain) {
  'use strict';




  /**
   * The Deployment model module.
   * @module model/Deployment
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>Deployment</code>.
   * Network deployment object
   * @alias module:model/Deployment
   * @class
   */
  var exports = function() {
    var _this = this;






  };

  /**
   * Constructs a <code>Deployment</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/Deployment} obj Optional instance to populate.
   * @return {module:model/Deployment} The populated <code>Deployment</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('interDomainLatency')) {
        obj['interDomainLatency'] = ApiClient.convertToType(data['interDomainLatency'], 'Number');
      }
      if (data.hasOwnProperty('interDomainLatencyVariation')) {
        obj['interDomainLatencyVariation'] = ApiClient.convertToType(data['interDomainLatencyVariation'], 'Number');
      }
      if (data.hasOwnProperty('interDomainThroughput')) {
        obj['interDomainThroughput'] = ApiClient.convertToType(data['interDomainThroughput'], 'Number');
      }
      if (data.hasOwnProperty('interDomainPacketLoss')) {
        obj['interDomainPacketLoss'] = ApiClient.convertToType(data['interDomainPacketLoss'], 'Number');
      }
      if (data.hasOwnProperty('domains')) {
        obj['domains'] = ApiClient.convertToType(data['domains'], [Domain]);
      }
    }
    return obj;
  }

  /**
   * Latency in ms between domains
   * @member {Number} interDomainLatency
   */
  exports.prototype['interDomainLatency'] = undefined;
  /**
   * Latency variation in ms between domains
   * @member {Number} interDomainLatencyVariation
   */
  exports.prototype['interDomainLatencyVariation'] = undefined;
  /**
   * The limit of the traffic supported between domains
   * @member {Number} interDomainThroughput
   */
  exports.prototype['interDomainThroughput'] = undefined;
  /**
   * Packet lost (in terms of percentage) between domains
   * @member {Number} interDomainPacketLoss
   */
  exports.prototype['interDomainPacketLoss'] = undefined;
  /**
   * @member {Array.<module:model/Domain>} domains
   */
  exports.prototype['domains'] = undefined;



  return exports;
}));


