/**
 * MEEP Controller REST API
 * Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Settings'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/Settings'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepControllerRestApi) {
      root.MeepControllerRestApi = {};
    }
    root.MeepControllerRestApi.MEEPSettingsApi = factory(root.MeepControllerRestApi.ApiClient, root.MeepControllerRestApi.Settings);
  }
}(this, function(ApiClient, Settings) {
  'use strict';

  /**
   * MEEPSettings service.
   * @module api/MEEPSettingsApi
   * @version 1.0.0
   */

  /**
   * Constructs a new MEEPSettingsApi. 
   * @alias module:api/MEEPSettingsApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the getMeepSettings operation.
     * @callback module:api/MEEPSettingsApi~getMeepSettingsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Settings} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve MEEP Controller settings
     * 
     * @param {module:api/MEEPSettingsApi~getMeepSettingsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Settings}
     */
    this.getMeepSettings = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = Settings;

      return this.apiClient.callApi(
        '/settings', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the setMeepSettings operation.
     * @callback module:api/MEEPSettingsApi~setMeepSettingsCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Set MEEP Controller settings
     * 
     * @param {module:model/Settings} settings MEEP Settings
     * @param {module:api/MEEPSettingsApi~setMeepSettingsCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.setMeepSettings = function(settings, callback) {
      var postBody = settings;

      // verify the required parameter 'settings' is set
      if (settings === undefined || settings === null) {
        throw new Error("Missing the required parameter 'settings' when calling setMeepSettings");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/settings', 'PUT',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
