# meep_controller_rest_api

MeepControllerRestApi - JavaScript client for meep_controller_rest_api
Copyright (c) 2019 InterDigital Communications, Inc. All rights reserved. The information provided herein is the proprietary and confidential information of InterDigital Communications, Inc. 
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install meep_controller_rest_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your meep_controller_rest_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('meep_controller_rest_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var MeepControllerRestApi = require('meep_controller_rest_api');

var api = new MeepControllerRestApi.MEEPSettingsApi()

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.getMeepSettings(callback);

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MeepControllerRestApi.MEEPSettingsApi* | [**getMeepSettings**](docs/MEEPSettingsApi.md#getMeepSettings) | **GET** /settings | Retrieve MEEP Controller settings
*MeepControllerRestApi.MEEPSettingsApi* | [**setMeepSettings**](docs/MEEPSettingsApi.md#setMeepSettings) | **PUT** /settings | Set MEEP Controller settings
*MeepControllerRestApi.PodStatesApi* | [**getStates**](docs/PodStatesApi.md#getStates) | **GET** /states | This operation returns status information for pods
*MeepControllerRestApi.ScenarioConfigurationApi* | [**createScenario**](docs/ScenarioConfigurationApi.md#createScenario) | **POST** /scenarios/{name} | Add new scenario to MEEP store
*MeepControllerRestApi.ScenarioConfigurationApi* | [**deleteScenario**](docs/ScenarioConfigurationApi.md#deleteScenario) | **DELETE** /scenarios/{name} | Delete scenario from MEEP store
*MeepControllerRestApi.ScenarioConfigurationApi* | [**deleteScenarioList**](docs/ScenarioConfigurationApi.md#deleteScenarioList) | **DELETE** /scenarios | Delete all scenarios in MEEP store
*MeepControllerRestApi.ScenarioConfigurationApi* | [**getScenario**](docs/ScenarioConfigurationApi.md#getScenario) | **GET** /scenarios/{name} | Retrieve scenario from MEEP store
*MeepControllerRestApi.ScenarioConfigurationApi* | [**getScenarioList**](docs/ScenarioConfigurationApi.md#getScenarioList) | **GET** /scenarios | Retrieve list of scenarios in MEEP store
*MeepControllerRestApi.ScenarioConfigurationApi* | [**setScenario**](docs/ScenarioConfigurationApi.md#setScenario) | **PUT** /scenarios/{name} | Update scenario in MEEP store
*MeepControllerRestApi.ScenarioExecutionApi* | [**activateScenario**](docs/ScenarioExecutionApi.md#activateScenario) | **POST** /active/{name} | Activate (deploy) scenario
*MeepControllerRestApi.ScenarioExecutionApi* | [**getActiveClientServiceMaps**](docs/ScenarioExecutionApi.md#getActiveClientServiceMaps) | **GET** /active/serviceMaps | Retrieve list of active external client service mappings
*MeepControllerRestApi.ScenarioExecutionApi* | [**getActiveScenario**](docs/ScenarioExecutionApi.md#getActiveScenario) | **GET** /active | Retrieve active (deployed) scenario
*MeepControllerRestApi.ScenarioExecutionApi* | [**getEventList**](docs/ScenarioExecutionApi.md#getEventList) | **GET** /events | Retrieve list of supported event types for active (deployed) scenario
*MeepControllerRestApi.ScenarioExecutionApi* | [**sendEvent**](docs/ScenarioExecutionApi.md#sendEvent) | **POST** /events/{type} | Send event to active (deployed) scenario
*MeepControllerRestApi.ScenarioExecutionApi* | [**terminateScenario**](docs/ScenarioExecutionApi.md#terminateScenario) | **DELETE** /active | Terminate active (deployed) scenario


## Documentation for Models

 - [MeepControllerRestApi.ClientServiceMap](docs/ClientServiceMap.md)
 - [MeepControllerRestApi.Deployment](docs/Deployment.md)
 - [MeepControllerRestApi.Domain](docs/Domain.md)
 - [MeepControllerRestApi.Event](docs/Event.md)
 - [MeepControllerRestApi.EventList](docs/EventList.md)
 - [MeepControllerRestApi.EventNetworkCharacteristicsUpdate](docs/EventNetworkCharacteristicsUpdate.md)
 - [MeepControllerRestApi.EventOther](docs/EventOther.md)
 - [MeepControllerRestApi.EventPoasInRange](docs/EventPoasInRange.md)
 - [MeepControllerRestApi.EventUeMobility](docs/EventUeMobility.md)
 - [MeepControllerRestApi.ExternalConfig](docs/ExternalConfig.md)
 - [MeepControllerRestApi.NetworkLocation](docs/NetworkLocation.md)
 - [MeepControllerRestApi.PhysicalLocation](docs/PhysicalLocation.md)
 - [MeepControllerRestApi.PodStatus](docs/PodStatus.md)
 - [MeepControllerRestApi.PodsStatus](docs/PodsStatus.md)
 - [MeepControllerRestApi.Process](docs/Process.md)
 - [MeepControllerRestApi.Scenario](docs/Scenario.md)
 - [MeepControllerRestApi.ScenarioConfig](docs/ScenarioConfig.md)
 - [MeepControllerRestApi.ScenarioList](docs/ScenarioList.md)
 - [MeepControllerRestApi.ServiceConfig](docs/ServiceConfig.md)
 - [MeepControllerRestApi.ServiceMap](docs/ServiceMap.md)
 - [MeepControllerRestApi.ServicePort](docs/ServicePort.md)
 - [MeepControllerRestApi.Settings](docs/Settings.md)
 - [MeepControllerRestApi.Zone](docs/Zone.md)


## Documentation for Authorization

 All endpoints do not require authorization.

