/*
 * MEEP Demo App API
 *
 * This is the MEEP Demo App API
 *
 * API version: 0.0.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package swagger

import (
	"encoding/json"
	"fmt"
	"net/http"
	"os"
	"strings"
)

func GetEdgeInfo(w http.ResponseWriter, r *http.Request) {
	w.Header().Set("Content-Type", "application/json; charset=UTF-8")

	var edgeInfo EdgeInfo
	//podName := os.Getenv("MEEP_POD_NAME")
	serviceName := os.Getenv("MGM_APP_ID")
	newString := strings.ToUpper(serviceName) + "_SERVICE_HOST"
	newString = strings.Replace(newString, "-", "_", -1)

	svcName := os.Getenv("MGM_GROUP_NAME")

	edgeInfo.Svc = svcName
	edgeInfo.Name = serviceName //podName
	edgeInfo.Ip = os.Getenv(newString)
	// Format response
	jsonResponse, err := json.Marshal(edgeInfo)
	if err != nil {
		http.Error(w, err.Error(), http.StatusInternalServerError)
		return
	}

	// Send response
	w.WriteHeader(http.StatusOK)
	fmt.Fprint(w, string(jsonResponse))
}
