/**
 * MEEP Demo App API
 * This is the MEEP Demo App API
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/MobilityGroupAppState'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./MobilityGroupAppState'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepDemoAppApi) {
      root.MeepDemoAppApi = {};
    }
    root.MeepDemoAppApi.MobilityGroupEvent = factory(root.MeepDemoAppApi.ApiClient, root.MeepDemoAppApi.MobilityGroupAppState);
  }
}(this, function(ApiClient, MobilityGroupAppState) {
  'use strict';




  /**
   * The MobilityGroupEvent model module.
   * @module model/MobilityGroupEvent
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>MobilityGroupEvent</code>.
   * Event object
   * @alias module:model/MobilityGroupEvent
   * @class
   */
  var exports = function() {
    var _this = this;





  };

  /**
   * Constructs a <code>MobilityGroupEvent</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/MobilityGroupEvent} obj Optional instance to populate.
   * @return {module:model/MobilityGroupEvent} The populated <code>MobilityGroupEvent</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('type')) {
        obj['type'] = ApiClient.convertToType(data['type'], 'String');
      }
      if (data.hasOwnProperty('ueId')) {
        obj['ueId'] = ApiClient.convertToType(data['ueId'], 'String');
      }
      if (data.hasOwnProperty('appState')) {
        obj['appState'] = MobilityGroupAppState.constructFromObject(data['appState']);
      }
    }
    return obj;
  }

  /**
   * Mobility Group event name
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * Mobility Group event type
   * @member {module:model/MobilityGroupEvent.TypeEnum} type
   */
  exports.prototype['type'] = undefined;
  /**
   * Mobility Group UE identifier
   * @member {String} ueId
   */
  exports.prototype['ueId'] = undefined;
  /**
   * @member {module:model/MobilityGroupAppState} appState
   */
  exports.prototype['appState'] = undefined;


  /**
   * Allowed values for the <code>type</code> property.
   * @enum {String}
   * @readonly
   */
  exports.TypeEnum = {
    /**
     * value: "STATE-UPDATE"
     * @const
     */
    "UPDATE": "STATE-UPDATE",
    /**
     * value: "STATE-TRANSFER-START"
     * @const
     */
    "TRANSFER-START": "STATE-TRANSFER-START",
    /**
     * value: "STATE-TRANSFER-COMPLETE"
     * @const
     */
    "TRANSFER-COMPLETE": "STATE-TRANSFER-COMPLETE",
    /**
     * value: "STATE-TRANSFER-CANCEL"
     * @const
     */
    "TRANSFER-CANCEL": "STATE-TRANSFER-CANCEL"  };


  return exports;
}));


