/**
 * MEEP Demo App API
 * This is the MEEP Demo App API
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/UeState'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/UeState'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepDemoAppApi) {
      root.MeepDemoAppApi = {};
    }
    root.MeepDemoAppApi.UEStateApi = factory(root.MeepDemoAppApi.ApiClient, root.MeepDemoAppApi.UeState);
  }
}(this, function(ApiClient, UeState) {
  'use strict';

  /**
   * UEState service.
   * @module api/UEStateApi
   * @version 0.0.1
   */

  /**
   * Constructs a new UEStateApi. 
   * @alias module:api/UEStateApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createUeState operation.
     * @callback module:api/UEStateApi~createUeStateCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Registers the UE and starts a counter
     * 
     * @param {String} ueId UE identifier
     * @param {module:api/UEStateApi~createUeStateCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.createUeState = function(ueId, callback) {
      var postBody = null;

      // verify the required parameter 'ueId' is set
      if (ueId === undefined || ueId === null) {
        throw new Error("Missing the required parameter 'ueId' when calling createUeState");
      }


      var pathParams = {
        'ueId': ueId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/ue/{ueId}', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteUe operation.
     * @callback module:api/UEStateApi~deleteUeCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deregistration of a UE
     * 
     * @param {String} ueId UE identifier
     * @param {module:api/UEStateApi~deleteUeCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteUe = function(ueId, callback) {
      var postBody = null;

      // verify the required parameter 'ueId' is set
      if (ueId === undefined || ueId === null) {
        throw new Error("Missing the required parameter 'ueId' when calling deleteUe");
      }


      var pathParams = {
        'ueId': ueId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/ue/{ueId}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getUeState operation.
     * @callback module:api/UEStateApi~getUeStateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UeState} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves the UE state values
     * 
     * @param {String} ueId UE identifier
     * @param {module:api/UEStateApi~getUeStateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UeState}
     */
    this.getUeState = function(ueId, callback) {
      var postBody = null;

      // verify the required parameter 'ueId' is set
      if (ueId === undefined || ueId === null) {
        throw new Error("Missing the required parameter 'ueId' when calling getUeState");
      }


      var pathParams = {
        'ueId': ueId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = UeState;

      return this.apiClient.callApi(
        '/ue/{ueId}', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateUeState operation.
     * @callback module:api/UEStateApi~updateUeStateCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates the UE states values
     * 
     * @param {String} ueId UE identifier
     * @param {module:model/UeState} ueState Ue state basic information
     * @param {module:api/UEStateApi~updateUeStateCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.updateUeState = function(ueId, ueState, callback) {
      var postBody = ueState;

      // verify the required parameter 'ueId' is set
      if (ueId === undefined || ueId === null) {
        throw new Error("Missing the required parameter 'ueId' when calling updateUeState");
      }

      // verify the required parameter 'ueState' is set
      if (ueState === undefined || ueState === null) {
        throw new Error("Missing the required parameter 'ueState' when calling updateUeState");
      }


      var pathParams = {
        'ueId': ueId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/ue/{ueId}', 'PUT',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
