---
layout: default
title: Home
nav_order: 1
description: "AdvantEDGE is a Mobile Edge Emulation Platform (MEEP) that runs on Docker & Kubernetes."
permalink: /
---

![AdvantEDGE-logo]({{site.baseurl}}/assets/images/AdvantEDGE-logo_Blue-01.png)

------

**_What's New in v1.8.1!_**

:zap: **Improved edge native services: Multiple fixes to [ETSI MEC011 - Edge Platform Application Enablement]({{site.baseurl}}{% link docs/overview/edge-services/overview-edge-services.md %}#edge-platform-application-enablement-service) and [ETSI MEC021 - Application Mobility Service]({{site.baseurl}}{% link docs/overview/edge-services/overview-edge-services.md %}#application-mobility-service)**

:zap: **New! [Demo3 example application]({{site.baseurl}}{% link docs/usage/usage-demo3.md %}) to showcase MEC011 & MEC021 service API usage**

:zap: **ETSI MEC028 WebSocket support: [ETSI MEC028 - WLAN Access Information Service]({{site.baseurl}}{% link docs/overview/edge-services/overview-edge-services.md %}#wireless-access-information-service) now supports WebSocket model for receiving notifications**

:zap: **Improved sandbox data management: [Sandbox Metrics Garbage Collection]({{site.baseurl}}{% link docs/overview/features/overview-features.md %}#sandbox-subsystem) :wastebasket: can be configured to periodically recover unused sandbox disk space**

:zap: **General maintenance :hammer_and_wrench:**

:zap: **Don't hesitate to reach out to us by initiating [GitHub Discussion](https://github.com/InterDigitalInc/AdvantEDGE/discussions) :octocat:**

------

## What is AdvantEDGE?
AdvantEDGE is a Mobile Edge Emulation Platform (MEEP) that runs on Docker & Kubernetes.

AdvantEDGE provides an emulation environment, enabling experimentation with Edge Computing Technologies, Applications, and Services.  The platform facilitates exploring edge / fog deployment models and their impact on applications and services in short and agile iterations.

### Motivation

- [x] **Accelerate Mobile Edge Computing adoption**
- [x] **Help Discover new edge application use cases & services**
- [x] **Help answer questions such as:**
<ul><ul>
<li>Where should my application components be located in the edge network?</li>
<li>How do network characteristics (such as latency, jitter, and packet loss) impact my application or service?</li>
<li>How will my application behave when the user moves within and across access networks?</li>
</ul></ul>

### Intended Users

- [x] **Edge Application Developers**
- [x] **Edge Network and Service Designers**
- [x] **Edge Researchers**
- [x] **Technologists that are simply interested learning how the Edge works**

## Getting started
[:one: :heavy_minus_sign: **Familiarize with Architecture and Features**]({{site.baseurl}}{% link docs/overview/overview-architecture.md %})

[:two: :heavy_minus_sign: **Setup environment**]({{site.baseurl}}{% link docs/setup/env-hw.md %})

[:three: :heavy_minus_sign: **Deploy platform**]({{site.baseurl}}{% link docs/platform-mgmt/mgmt-workflow.md %})

[:four: :heavy_minus_sign: **Start using AdvantEDGE**]({{site.baseurl}}{% link docs/usage/usage-workflow.md %})

## How to Contribute
If you like this project and would like to participate in its evolution, you can find information on contributing [**here**](https://github.com/InterDigitalInc/AdvantEDGE/blob/master/CONTRIBUTING.md)

We welcome questions, feedback and improvement suggestions via [:octocat:**Discussion**](https://github.com/InterDigitalInc/AdvantEDGE/discussions) and bugs reporting via [:octocat: **Issues**](https://github.com/InterDigitalInc/AdvantEDGE/issues)

Hope to hear from you...

## Licensing

AdvantEDGE is licensed under under the [**Apache License, Version 2.0**](https://github.com/InterDigitalInc/AdvantEDGE/blob/master/LICENSE)
