/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](.https://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/03.02.01_60/) <p>[Copyright (c) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of VIS API endpoints (see below) and a subset of subscription types.
 *
 * API version: 3.2.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type V2xMsgFilterCriteria struct {
	// Location information to identify a cell of a base station or a particular geographical area to which the V2X message can be associated.
	LocationInfo []LocationInfo `json:"locationInfo,omitempty"`
	// Protocol version of the V2X message (0..255), See note 3.
	MsgProtocolVersion []int32 `json:"msgProtocolVersion,omitempty"`
	// Published V2X message type. Its value is defined by the standardization organization indicated by the attribute stdOrganization. See note 2.
	MsgType []string `json:"msgType,omitempty"`
	// Standardization organization which defines the published V2X message type:  ETSI: European Telecommunications Standards Institute.  See note 1.
	StdOrganization string `json:"stdOrganization"`
}
