# swagger-client
The MEC Sandbox API described using OpenAPI

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.7
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = swagger_client.AuthorizationApi(swagger_client.ApiClient(configuration))
provider = 'provider_example' # str | Oauth provider

try:
    # Initiate OAuth login procedure and creates a MEC Sandbox instance
    api_response = api_instance.login(provider)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthorizationApi->login: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.AuthorizationApi(swagger_client.ApiClient(configuration))
sandbox_name = 'sandbox_name_example' # str | Sandbox identifier

try:
    # Terminates User Session and delete the Sandbox instance
    api_instance.logout(sandbox_name)
except ApiException as e:
    print("Exception when calling AuthorizationApi->logout: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/sandbox-api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizationApi* | [**login**](docs/AuthorizationApi.md#login) | **POST** /login | Initiate OAuth login procedure and creates a MEC Sandbox instance
*AuthorizationApi* | [**logout**](docs/AuthorizationApi.md#logout) | **POST** /logout | Terminates User Session and delete the Sandbox instance
*SandboxAppInstancesApi* | [**sandbox_app_instances_delete**](docs/SandboxAppInstancesApi.md#sandbox_app_instances_delete) | **DELETE** /sandboxAppInstances/{sandbox_name}/{app_instance_id} | Delete an existing application instance
*SandboxAppInstancesApi* | [**sandbox_app_instances_get**](docs/SandboxAppInstancesApi.md#sandbox_app_instances_get) | **GET** /sandboxAppInstances/{sandbox_name} | Get the list of the available application instance identifiers
*SandboxAppInstancesApi* | [**sandbox_app_instances_post**](docs/SandboxAppInstancesApi.md#sandbox_app_instances_post) | **POST** /sandboxAppInstances/{sandbox_name} | Create a new application instance identifier
*SandboxLogsSubscriptionsApi* | [**sandbox_logs_subscriptions_delete**](docs/SandboxLogsSubscriptionsApi.md#sandbox_logs_subscriptions_delete) | **DELETE** /sandboxLogsSubscriptions/{sandbox_name}/{subscription_reference} | Subscription to receive logs from the sandbox
*SandboxLogsSubscriptionsApi* | [**sandbox_logs_subscriptions_post**](docs/SandboxLogsSubscriptionsApi.md#sandbox_logs_subscriptions_post) | **POST** /sandboxLogsSubscriptions/{sandbox_name} | Subscription to receive logs from the sandbox
*SandboxMECServicesApi* | [**sandbox_mec_services_get**](docs/SandboxMECServicesApi.md#sandbox_mec_services_get) | **GET** /sandboxMecServices/{sandbox_name} | Get the list of the available MEC services
*SandboxNetworkScenariosApi* | [**sandbox_individual_network_scenarios_get**](docs/SandboxNetworkScenariosApi.md#sandbox_individual_network_scenarios_get) | **GET** /sandboxNetworkScenarios/{sandbox_name} | Get description of a Network Scenario to be used.
*SandboxNetworkScenariosApi* | [**sandbox_network_scenario_delete**](docs/SandboxNetworkScenariosApi.md#sandbox_network_scenario_delete) | **DELETE** /sandboxNetworkScenarios/{sandbox_name}/{network_scenario_id} | Deactivate the Network Scenario.
*SandboxNetworkScenariosApi* | [**sandbox_network_scenario_post**](docs/SandboxNetworkScenariosApi.md#sandbox_network_scenario_post) | **POST** /sandboxNetworkScenarios/{sandbox_name} | Selects the Network Scenario to be activated.
*SandboxNetworkScenariosApi* | [**sandbox_network_scenarios_get**](docs/SandboxNetworkScenariosApi.md#sandbox_network_scenarios_get) | **GET** /sandboxNetworkScenarios | Get the list of the available network scenarios
*SandboxUEControllerApi* | [**sandbox_ue_controller_get**](docs/SandboxUEControllerApi.md#sandbox_ue_controller_get) | **GET** /sandboxUeController/{sandbox_name} | Get the list of the available UEs (e.g. \&quot;Stationary UE\&quot;)
*SandboxUEControllerApi* | [**sandbox_ue_controller_patch**](docs/SandboxUEControllerApi.md#sandbox_ue_controller_patch) | **PATCH** /sandboxUeController/{sandbox_name} | set the new value of the UE

## Documentation For Models

 - [ApplicationInfo](docs/ApplicationInfo.md)
 - [CellularDomainConfig](docs/CellularDomainConfig.md)
 - [CellularPoaConfig](docs/CellularPoaConfig.md)
 - [ConnectivityConfig](docs/ConnectivityConfig.md)
 - [CpuConfig](docs/CpuConfig.md)
 - [D2dConfig](docs/D2dConfig.md)
 - [DNConfig](docs/DNConfig.md)
 - [Deployment](docs/Deployment.md)
 - [Domain](docs/Domain.md)
 - [EgressService](docs/EgressService.md)
 - [ExternalConfig](docs/ExternalConfig.md)
 - [GeoData](docs/GeoData.md)
 - [GpuConfig](docs/GpuConfig.md)
 - [IngressService](docs/IngressService.md)
 - [LineString](docs/LineString.md)
 - [MemoryConfig](docs/MemoryConfig.md)
 - [NetworkCharacteristics](docs/NetworkCharacteristics.md)
 - [NetworkLocation](docs/NetworkLocation.md)
 - [PhysicalLocation](docs/PhysicalLocation.md)
 - [Poa4GConfig](docs/Poa4GConfig.md)
 - [Poa5GConfig](docs/Poa5GConfig.md)
 - [PoaWifiConfig](docs/PoaWifiConfig.md)
 - [Point](docs/Point.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [Process](docs/Process.md)
 - [Sandbox](docs/Sandbox.md)
 - [SandboxAppInstances](docs/SandboxAppInstances.md)
 - [SandboxLogsSubscriptions](docs/SandboxLogsSubscriptions.md)
 - [SandboxMecServices](docs/SandboxMecServices.md)
 - [SandboxNetworkScenario](docs/SandboxNetworkScenario.md)
 - [Scenario](docs/Scenario.md)
 - [ScenarioConfig](docs/ScenarioConfig.md)
 - [ServiceConfig](docs/ServiceConfig.md)
 - [ServicePort](docs/ServicePort.md)
 - [UE](docs/UE.md)
 - [Zone](docs/Zone.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author

cti_support@etsi.org
