Demo 6 is a MEC application to illustrate the usage of the MEC Sandbox command line APIs.

# How to use it

## Building the demo6 application

go version 1.18+ is required to build demo 6

There is two ways to build demo6 application:
- Using the docker_build.sh script

```sh
~$ docker pull golang
~$ cd ~/AdvantEDGE/examples/demo6 
~/AdvantEDGE/examples/demo6$ docker_build.sh
```

- Manually:

```sh
~$ docker pull golang
~$ cd ~/AdvantEDGE/examples/demo6 
~/AdvantEDGE/examples/demo6$ docker run --rm -it -v$PWD:/opt/local/etsi/demo6 golang
root@56c7b1ce74ca:/go# cd /opt/local/etsi/demo6
root@56c7b1ce74ca:/opt/local/etsi/demo6# go run ./main.go
```

## Executing the demo6 application

The demo6 application can be executed using the script run.sh:

```sh
~$ cd ~/AdvantEDGE/examples/demo6 
~/AdvantEDGE/examples/demo6$ docker_run.sh
```

# Menu description

Below is the menu proposed by the demo6 application:

```sh
Mandatory commands:
        l: Login, L: Logout, s: Get scenarios list
        a <index>: Activate a scenario, d <index>: Terminate a scenario
Optional commands:
        S <index>: Get scenario description
        m: Get MEC services list
        i: Get application instances list, c: Create a new application instance, D: Delete a new application instance
MEC 030:
        u: Get V2X UU unicast setting
q: Quit
Enter your choice:
```

## Mandatories commands

Mandatories commands are the sequence of command to execute before to execute with the optionals commands.

### Login command

The Login command (l) authenticates and authorizes the MEC application demo6 and creates a new MEC sandbox instance.

### Logout command

The Logout command (L) terminates an existing MEC sandbox instance.

### Get scenarios list

After the login step, it is mandatory to request the list of available network scenarios in order to execute with the optional commands.

## Optional commands

### Get scenario description

This option (S) uses the index of the network scenario (starting from 0) to retrieve the description of the selected network scenario.

### Activate a network scenario

This option (a) uses the index of the network scenario (starting from 0) to activate the selected network scenario. This command requests the MEC Sandbox instance to start all the MEC services attached to the activated network scenario.

### Deactivate a network scenario

This option (d) uses the index of the network scenario (starting from 0) to deactivate the selected network scenario. This command requests the MEC Sandbox instance to terminate all the MEC services attached to the activated network scenario.

### Get MEC services list

This option (m) retrieves the list of the MEC services available with the activated network scenario.

### Get application instances list

This option (i) retrieves the list of the MEC applications available with the activated network scenario.

### Create a new application instance

This option (c) creates the a new USER MEC application. The application instance id is generated automatically and its name is "demo6".
This new application is attached to "mep1".

### Delete a new application instance

This option (D) terminates an existing MEC application.

## MEC Services commands

Theses commands provides some example of access to the MEC services available with the activated network scenario.

### Get V2X UU unicast setting

This option (u) retrieve the UU Unicast settings from the MEC 030 service. To use it, the V2X network scenarion shall be activated (see [Activate a network scenario](#activate_a_network_scenario)).

## Terminate the demo6 application

The command Quit (q) terminates the demo6 application. If a Login commands was executed, the termination process does the logout.
