/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ScenarioNode'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ScenarioNode'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeSandboxControllerRestApi) {
      root.AdvantEdgeSandboxControllerRestApi = {};
    }
    root.AdvantEdgeSandboxControllerRestApi.EventScenarioUpdate = factory(root.AdvantEdgeSandboxControllerRestApi.ApiClient, root.AdvantEdgeSandboxControllerRestApi.ScenarioNode);
  }
}(this, function(ApiClient, ScenarioNode) {
  'use strict';

  /**
   * The EventScenarioUpdate model module.
   * @module model/EventScenarioUpdate
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>EventScenarioUpdate</code>.
   * Scenario Update Event object.<br> Specifies a scenario update action to perform on the provided node. <p>Supported Actions: <li>ADD - Add node to scenario. Only the provided node is added; child nodes in node data are ignored. <li>REMOVE - Remove node from scenario. Only node name is required in node data for this action; parent is ignored. <li>MODIFY - Modifies scenario node. <p>NOTES: <li>Current backend implementation supports only PhysicalLocation & Process network elements. <li>Grace period only applies when removing a node. Default value is 0, triggering an immediate node removal.
   * @alias module:model/EventScenarioUpdate
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>EventScenarioUpdate</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/EventScenarioUpdate} obj Optional instance to populate.
   * @return {module:model/EventScenarioUpdate} The populated <code>EventScenarioUpdate</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('action'))
        obj.action = ApiClient.convertToType(data['action'], 'String');
      if (data.hasOwnProperty('node'))
        obj.node = ScenarioNode.constructFromObject(data['node']);
      if (data.hasOwnProperty('gracePeriod'))
        obj.gracePeriod = ApiClient.convertToType(data['gracePeriod'], 'Number');
    }
    return obj;
  }

  /**
   * Action to perform on provided scenario node
   * @member {module:model/EventScenarioUpdate.ActionEnum} action
   */
  exports.prototype.action = undefined;

  /**
   * @member {module:model/ScenarioNode} node
   */
  exports.prototype.node = undefined;

  /**
   * Grace period in seconds before forcefully removing node
   * @member {Number} gracePeriod
   */
  exports.prototype.gracePeriod = undefined;


  /**
   * Allowed values for the <code>action</code> property.
   * @enum {String}
   * @readonly
   */
  exports.ActionEnum = {
    /**
     * value: "ADD"
     * @const
     */
    ADD: "ADD",

    /**
     * value: "REMOVE"
     * @const
     */
    REMOVE: "REMOVE",

    /**
     * value: "MODIFY"
     * @const
     */
    MODIFY: "MODIFY"
  };

  return exports;

}));
