/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Platform Controller REST API
 * This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Sandbox', 'model/SandboxConfig', 'model/SandboxList'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/Sandbox'), require('../model/SandboxConfig'), require('../model/SandboxList'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgePlatformControllerRestApi) {
      root.AdvantEdgePlatformControllerRestApi = {};
    }
    root.AdvantEdgePlatformControllerRestApi.SandboxControlApi = factory(root.AdvantEdgePlatformControllerRestApi.ApiClient, root.AdvantEdgePlatformControllerRestApi.Sandbox, root.AdvantEdgePlatformControllerRestApi.SandboxConfig, root.AdvantEdgePlatformControllerRestApi.SandboxList);
  }
}(this, function(ApiClient, Sandbox, SandboxConfig, SandboxList) {
  'use strict';

  /**
   * SandboxControl service.
   * @module api/SandboxControlApi
   * @version 1.0.0
   */

  /**
   * Constructs a new SandboxControlApi. 
   * @alias module:api/SandboxControlApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createSandbox operation.
     * @callback module:api/SandboxControlApi~createSandboxCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Sandbox} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new sandbox
     * Create a new sandbox with a server-generated name
     * @param {module:model/SandboxConfig} config Sandbox configuration information
     * @param {module:api/SandboxControlApi~createSandboxCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Sandbox}
     */
    this.createSandbox = function(config, callback) {
      var postBody = config;

      // verify the required parameter 'config' is set
      if (config === undefined || config === null) {
        throw new Error("Missing the required parameter 'config' when calling createSandbox");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = Sandbox;

      return this.apiClient.callApi(
        '/sandboxes', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createSandboxWithName operation.
     * @callback module:api/SandboxControlApi~createSandboxWithNameCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new sandbox
     * Create a new sandbox using provided name
     * @param {String} name Sandbox name
     * @param {module:model/SandboxConfig} config Sandbox configuration information
     * @param {module:api/SandboxControlApi~createSandboxWithNameCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.createSandboxWithName = function(name, config, callback) {
      var postBody = config;

      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling createSandboxWithName");
      }

      // verify the required parameter 'config' is set
      if (config === undefined || config === null) {
        throw new Error("Missing the required parameter 'config' when calling createSandboxWithName");
      }


      var pathParams = {
        'name': name
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/sandboxes/{name}', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteSandbox operation.
     * @callback module:api/SandboxControlApi~deleteSandboxCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a specific sandbox
     * Delete the sandbox with the provided name
     * @param {String} name Sandbox name
     * @param {module:api/SandboxControlApi~deleteSandboxCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteSandbox = function(name, callback) {
      var postBody = null;

      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling deleteSandbox");
      }


      var pathParams = {
        'name': name
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/sandboxes/{name}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteSandboxList operation.
     * @callback module:api/SandboxControlApi~deleteSandboxListCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete all active sandboxes
     * Delete all active sandboxes
     * @param {module:api/SandboxControlApi~deleteSandboxListCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteSandboxList = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/sandboxes', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getSandbox operation.
     * @callback module:api/SandboxControlApi~getSandboxCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Sandbox} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a specific sandbox
     * Get sandbox information for provided sandbox name
     * @param {String} name Sandbox name
     * @param {module:api/SandboxControlApi~getSandboxCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Sandbox}
     */
    this.getSandbox = function(name, callback) {
      var postBody = null;

      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getSandbox");
      }


      var pathParams = {
        'name': name
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = Sandbox;

      return this.apiClient.callApi(
        '/sandboxes/{name}', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getSandboxList operation.
     * @callback module:api/SandboxControlApi~getSandboxListCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SandboxList} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all active sandboxes
     * Returns a list of all active sandboxes
     * @param {module:api/SandboxControlApi~getSandboxListCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SandboxList}
     */
    this.getSandboxList = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = SandboxList;

      return this.apiClient.callApi(
        '/sandboxes', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
