/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Scope', 'model/Tag'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./Scope'), require('./Tag'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeMetricsServiceRestApi) {
      root.AdvantEdgeMetricsServiceRestApi = {};
    }
    root.AdvantEdgeMetricsServiceRestApi.NetworkQueryParams = factory(root.AdvantEdgeMetricsServiceRestApi.ApiClient, root.AdvantEdgeMetricsServiceRestApi.Scope, root.AdvantEdgeMetricsServiceRestApi.Tag);
  }
}(this, function(ApiClient, Scope, Tag) {
  'use strict';

  /**
   * The NetworkQueryParams model module.
   * @module model/NetworkQueryParams
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>NetworkQueryParams</code>.
   * Network metrics query parameters
   * @alias module:model/NetworkQueryParams
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>NetworkQueryParams</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/NetworkQueryParams} obj Optional instance to populate.
   * @return {module:model/NetworkQueryParams} The populated <code>NetworkQueryParams</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('tags'))
        obj.tags = ApiClient.convertToType(data['tags'], [Tag]);
      if (data.hasOwnProperty('fields'))
        obj.fields = ApiClient.convertToType(data['fields'], ['String']);
      if (data.hasOwnProperty('scope'))
        obj.scope = Scope.constructFromObject(data['scope']);
    }
    return obj;
  }

  /**
   * Tag names to match in query. Supported values:<br> <li>src: Source network element name <li>dest: Destination network element name
   * @member {Array.<module:model/Tag>} tags
   */
  exports.prototype.tags = undefined;

  /**
   * Field names to return in query response. Supported values:<br> <li>lat: Round-trip latency (ms)<br> <li>ul: Uplink throughput from src to dest (Mbps) <li>dl: Downlink throughput from dest to src (Mbps) <li>ulos: Uplink packet loss from src to dest (%) <li>dlos: Downlink packet loss from dest to src (%)
   * @member {Array.<module:model/NetworkQueryParams.FieldsEnum>} fields
   */
  exports.prototype.fields = undefined;

  /**
   * @member {module:model/Scope} scope
   */
  exports.prototype.scope = undefined;


  /**
   * Allowed values for the <code>fields</code> property.
   * @enum {String}
   * @readonly
   */
  exports.FieldsEnum = {
    /**
     * value: "lat"
     * @const
     */
    lat: "lat",

    /**
     * value: "ul"
     * @const
     */
    ul: "ul",

    /**
     * value: "dl"
     * @const
     */
    dl: "dl",

    /**
     * value: "ulos"
     * @const
     */
    ulos: "ulos",

    /**
     * value: "dlos"
     * @const
     */
    dlos: "dlos"
  };

  return exports;

}));
