/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Scope', 'model/Tag'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./Scope'), require('./Tag'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeMetricsServiceRestApi) {
      root.AdvantEdgeMetricsServiceRestApi = {};
    }
    root.AdvantEdgeMetricsServiceRestApi.HttpQueryParams = factory(root.AdvantEdgeMetricsServiceRestApi.ApiClient, root.AdvantEdgeMetricsServiceRestApi.Scope, root.AdvantEdgeMetricsServiceRestApi.Tag);
  }
}(this, function(ApiClient, Scope, Tag) {
  'use strict';

  /**
   * The HttpQueryParams model module.
   * @module model/HttpQueryParams
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>HttpQueryParams</code>.
   * Http metrics query parameters
   * @alias module:model/HttpQueryParams
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>HttpQueryParams</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/HttpQueryParams} obj Optional instance to populate.
   * @return {module:model/HttpQueryParams} The populated <code>HttpQueryParams</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('tags'))
        obj.tags = ApiClient.convertToType(data['tags'], [Tag]);
      if (data.hasOwnProperty('fields'))
        obj.fields = ApiClient.convertToType(data['fields'], ['String']);
      if (data.hasOwnProperty('scope'))
        obj.scope = Scope.constructFromObject(data['scope']);
    }
    return obj;
  }

  /**
   * Tag names to match in query. Supported values:<br> <li>logger_name: Logger instances that issued the http notification or processed the request <li>direction: Notification or Request type of http metric
   * @member {Array.<module:model/Tag>} tags
   */
  exports.prototype.tags = undefined;

  /**
   * Field names to return in query response. Supported values:<br> <li>id: Http metrics identifier<br> <li>endpoint: Http metrics queried endpoint<br> <li>url: Http metrics queried endpoint with query parameters<br> <li>method: Http metrics method<br> <li>resp_code: Http metrics response status code<br> <li>resp_body: Http metrics response body<br> <li>body: Http metrics body<br> <li>proc_time: Request processing time in ms
   * @member {Array.<module:model/HttpQueryParams.FieldsEnum>} fields
   */
  exports.prototype.fields = undefined;

  /**
   * @member {module:model/Scope} scope
   */
  exports.prototype.scope = undefined;


  /**
   * Allowed values for the <code>fields</code> property.
   * @enum {String}
   * @readonly
   */
  exports.FieldsEnum = {
    /**
     * value: "id"
     * @const
     */
    id: "id",

    /**
     * value: "endpoint"
     * @const
     */
    endpoint: "endpoint",

    /**
     * value: "url"
     * @const
     */
    url: "url",

    /**
     * value: "method"
     * @const
     */
    method: "method",

    /**
     * value: "resp_code"
     * @const
     */
    respCode: "resp_code",

    /**
     * value: "resp_body"
     * @const
     */
    respBody: "resp_body",

    /**
     * value: "body"
     * @const
     */
    body: "body",

    /**
     * value: "proc_time"
     * @const
     */
    procTime: "proc_time",

    /**
     * value: "logger_name"
     * @const
     */
    loggerName: "logger_name",

    /**
     * value: "direction"
     * @const
     */
    direction: "direction"
  };

  return exports;

}));
