# advant_edge_metrics_service_rest_api

AdvantEdgeMetricsServiceRestApi - JavaScript client for advant_edge_metrics_service_rest_api
Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install advant_edge_metrics_service_rest_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your advant_edge_metrics_service_rest_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('advant_edge_metrics_service_rest_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var AdvantEdgeMetricsServiceRestApi = require('advant_edge_metrics_service_rest_api');

var api = new AdvantEdgeMetricsServiceRestApi.MetricsApi()

var params = new AdvantEdgeMetricsServiceRestApi.EventQueryParams(); // {EventQueryParams} Query parameters


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.postEventQuery(params, callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/metrics/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdvantEdgeMetricsServiceRestApi.MetricsApi* | [**postEventQuery**](docs/MetricsApi.md#postEventQuery) | **POST** /metrics/query/event | 
*AdvantEdgeMetricsServiceRestApi.MetricsApi* | [**postHttpQuery**](docs/MetricsApi.md#postHttpQuery) | **POST** /metrics/query/http | 
*AdvantEdgeMetricsServiceRestApi.MetricsApi* | [**postNetworkQuery**](docs/MetricsApi.md#postNetworkQuery) | **POST** /metrics/query/network | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**createEventSubscription**](docs/SubscriptionsApi.md#createEventSubscription) | **POST** /metrics/subscriptions/event | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**createNetworkSubscription**](docs/SubscriptionsApi.md#createNetworkSubscription) | **POST** /metrics/subscriptions/network | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**deleteEventSubscriptionById**](docs/SubscriptionsApi.md#deleteEventSubscriptionById) | **DELETE** /metrics/subscriptions/event/{subscriptionId} | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**deleteNetworkSubscriptionById**](docs/SubscriptionsApi.md#deleteNetworkSubscriptionById) | **DELETE** /metrics/subscriptions/network/{subscriptionId} | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**getEventSubscription**](docs/SubscriptionsApi.md#getEventSubscription) | **GET** /metrics/subscriptions/event | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**getEventSubscriptionById**](docs/SubscriptionsApi.md#getEventSubscriptionById) | **GET** /metrics/subscriptions/event/{subscriptionId} | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**getNetworkSubscription**](docs/SubscriptionsApi.md#getNetworkSubscription) | **GET** /metrics/subscriptions/network | 
*AdvantEdgeMetricsServiceRestApi.SubscriptionsApi* | [**getNetworkSubscriptionById**](docs/SubscriptionsApi.md#getNetworkSubscriptionById) | **GET** /metrics/subscriptions/network/{subscriptionId} | 


## Documentation for Models

 - [AdvantEdgeMetricsServiceRestApi.EventMetric](docs/EventMetric.md)
 - [AdvantEdgeMetricsServiceRestApi.EventMetricList](docs/EventMetricList.md)
 - [AdvantEdgeMetricsServiceRestApi.EventQueryParams](docs/EventQueryParams.md)
 - [AdvantEdgeMetricsServiceRestApi.EventSubscription](docs/EventSubscription.md)
 - [AdvantEdgeMetricsServiceRestApi.EventSubscriptionList](docs/EventSubscriptionList.md)
 - [AdvantEdgeMetricsServiceRestApi.EventSubscriptionParams](docs/EventSubscriptionParams.md)
 - [AdvantEdgeMetricsServiceRestApi.EventsCallbackReference](docs/EventsCallbackReference.md)
 - [AdvantEdgeMetricsServiceRestApi.HttpMetric](docs/HttpMetric.md)
 - [AdvantEdgeMetricsServiceRestApi.HttpMetricList](docs/HttpMetricList.md)
 - [AdvantEdgeMetricsServiceRestApi.HttpQueryParams](docs/HttpQueryParams.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkCallbackReference](docs/NetworkCallbackReference.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkMetric](docs/NetworkMetric.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkMetricList](docs/NetworkMetricList.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkQueryParams](docs/NetworkQueryParams.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkSubscription](docs/NetworkSubscription.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkSubscriptionList](docs/NetworkSubscriptionList.md)
 - [AdvantEdgeMetricsServiceRestApi.NetworkSubscriptionParams](docs/NetworkSubscriptionParams.md)
 - [AdvantEdgeMetricsServiceRestApi.Scope](docs/Scope.md)
 - [AdvantEdgeMetricsServiceRestApi.Tag](docs/Tag.md)


## Documentation for Authorization

 All endpoints do not require authorization.

