/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE GIS Engine REST API
 * This API allows to control geo-spatial behavior and simulation. <p>**Micro-service**<br>[meep-gis-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-gis-engine) <p>**Type & Usage**<br>Platform runtime interface to control geo-spatial behavior and simulation <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeGisEngineRestApi) {
      root.AdvantEdgeGisEngineRestApi = {};
    }
    root.AdvantEdgeGisEngineRestApi.WithinRange = factory(root.AdvantEdgeGisEngineRestApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The WithinRange model module.
   * @module model/WithinRange
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>WithinRange</code>.
   * Within range response
   * @alias module:model/WithinRange
   * @class
   * @param within {Boolean} Within range result (e.g. true = within range, false = beyond range)
   */
  var exports = function(within) {
    this.within = within;
  };

  /**
   * Constructs a <code>WithinRange</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/WithinRange} obj Optional instance to populate.
   * @return {module:model/WithinRange} The populated <code>WithinRange</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('srcLatitude'))
        obj.srcLatitude = ApiClient.convertToType(data['srcLatitude'], 'Number');
      if (data.hasOwnProperty('srcLongitude'))
        obj.srcLongitude = ApiClient.convertToType(data['srcLongitude'], 'Number');
      if (data.hasOwnProperty('dstLatitude'))
        obj.dstLatitude = ApiClient.convertToType(data['dstLatitude'], 'Number');
      if (data.hasOwnProperty('dstLongitude'))
        obj.dstLongitude = ApiClient.convertToType(data['dstLongitude'], 'Number');
      if (data.hasOwnProperty('within'))
        obj.within = ApiClient.convertToType(data['within'], 'Boolean');
    }
    return obj;
  }

  /**
   * Source asset latitude
   * @member {Number} srcLatitude
   */
  exports.prototype.srcLatitude = undefined;

  /**
   * Source asset longitude
   * @member {Number} srcLongitude
   */
  exports.prototype.srcLongitude = undefined;

  /**
   * Destination asset latitude
   * @member {Number} dstLatitude
   */
  exports.prototype.dstLatitude = undefined;

  /**
   * Destination asset longitude
   * @member {Number} dstLongitude
   */
  exports.prototype.dstLongitude = undefined;

  /**
   * Within range result (e.g. true = within range, false = beyond range)
   * @member {Boolean} within
   */
  exports.prototype.within = undefined;

  return exports;

}));
