# Go API client for client

MEC Service Management Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC011 Application Enablement API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/011/02.01.01_60/gs_MEC011v020101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-app-enablement](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-app-enablement/server/service-mgmt) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about services in the network <p>**Note**<br>AdvantEDGE supports all of Service Management API endpoints (see below).

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/mec_service_mgmt/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MecServiceMgmtApi* | [**AppServicesGET**](docs/MecServiceMgmtApi.md#appservicesget) | **Get** /applications/{appInstanceId}/services | 
*MecServiceMgmtApi* | [**AppServicesPOST**](docs/MecServiceMgmtApi.md#appservicespost) | **Post** /applications/{appInstanceId}/services | 
*MecServiceMgmtApi* | [**AppServicesServiceIdDELETE**](docs/MecServiceMgmtApi.md#appservicesserviceiddelete) | **Delete** /applications/{appInstanceId}/services/{serviceId} | 
*MecServiceMgmtApi* | [**AppServicesServiceIdGET**](docs/MecServiceMgmtApi.md#appservicesserviceidget) | **Get** /applications/{appInstanceId}/services/{serviceId} | 
*MecServiceMgmtApi* | [**AppServicesServiceIdPUT**](docs/MecServiceMgmtApi.md#appservicesserviceidput) | **Put** /applications/{appInstanceId}/services/{serviceId} | 
*MecServiceMgmtApi* | [**ApplicationsSubscriptionDELETE**](docs/MecServiceMgmtApi.md#applicationssubscriptiondelete) | **Delete** /applications/{appInstanceId}/subscriptions/{subscriptionId} | 
*MecServiceMgmtApi* | [**ApplicationsSubscriptionGET**](docs/MecServiceMgmtApi.md#applicationssubscriptionget) | **Get** /applications/{appInstanceId}/subscriptions/{subscriptionId} | 
*MecServiceMgmtApi* | [**ApplicationsSubscriptionsGET**](docs/MecServiceMgmtApi.md#applicationssubscriptionsget) | **Get** /applications/{appInstanceId}/subscriptions | 
*MecServiceMgmtApi* | [**ApplicationsSubscriptionsPOST**](docs/MecServiceMgmtApi.md#applicationssubscriptionspost) | **Post** /applications/{appInstanceId}/subscriptions | 
*MecServiceMgmtApi* | [**ServicesGET**](docs/MecServiceMgmtApi.md#servicesget) | **Get** /services | 
*MecServiceMgmtApi* | [**ServicesServiceIdGET**](docs/MecServiceMgmtApi.md#servicesserviceidget) | **Get** /services/{serviceId} | 
*MecServiceMgmtApi* | [**TransportsGET**](docs/MecServiceMgmtApi.md#transportsget) | **Get** /transports | 


## Documentation For Models

 - [CategoryRef](docs/CategoryRef.md)
 - [EndPointInfoAddresses](docs/EndPointInfoAddresses.md)
 - [EndPointInfoAddressesAddresses](docs/EndPointInfoAddressesAddresses.md)
 - [EndPointInfoAlternative](docs/EndPointInfoAlternative.md)
 - [EndPointInfoUris](docs/EndPointInfoUris.md)
 - [GrantType](docs/GrantType.md)
 - [LinkType](docs/LinkType.md)
 - [LocalityType](docs/LocalityType.md)
 - [OAuth2Info](docs/OAuth2Info.md)
 - [OneOfServiceInfoPost](docs/OneOfServiceInfoPost.md)
 - [OneOfTransportInfoEndpoint](docs/OneOfTransportInfoEndpoint.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [SecurityInfo](docs/SecurityInfo.md)
 - [Self](docs/Self.md)
 - [SerAvailabilityNotificationSubscription](docs/SerAvailabilityNotificationSubscription.md)
 - [SerAvailabilityNotificationSubscriptionFilteringCriteria](docs/SerAvailabilityNotificationSubscriptionFilteringCriteria.md)
 - [SerializerType](docs/SerializerType.md)
 - [ServiceAvailabilityNotification](docs/ServiceAvailabilityNotification.md)
 - [ServiceAvailabilityNotificationServiceReferences](docs/ServiceAvailabilityNotificationServiceReferences.md)
 - [ServiceInfo](docs/ServiceInfo.md)
 - [ServiceInfoPost](docs/ServiceInfoPost.md)
 - [ServiceState](docs/ServiceState.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListLinks](docs/SubscriptionLinkListLinks.md)
 - [SubscriptionLinkListLinksSubscriptions](docs/SubscriptionLinkListLinksSubscriptions.md)
 - [TransportInfo](docs/TransportInfo.md)
 - [TransportType](docs/TransportType.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

