# Go API client for client

This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/sandbox-ctrl/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActiveScenarioApi* | [**ActivateScenario**](docs/ActiveScenarioApi.md#activatescenario) | **Post** /active/{name} | Deploy a scenario
*ActiveScenarioApi* | [**GetActiveNodeServiceMaps**](docs/ActiveScenarioApi.md#getactivenodeservicemaps) | **Get** /active/serviceMaps | Get deployed scenario&#39;s port mapping
*ActiveScenarioApi* | [**GetActiveScenario**](docs/ActiveScenarioApi.md#getactivescenario) | **Get** /active | Get the deployed scenario
*ActiveScenarioApi* | [**GetActiveScenarioDomain**](docs/ActiveScenarioApi.md#getactivescenariodomain) | **Get** /active/domains | Get domain elements from the deployed scenario
*ActiveScenarioApi* | [**GetActiveScenarioNetworkLocation**](docs/ActiveScenarioApi.md#getactivescenarionetworklocation) | **Get** /active/networkLocations | Get network location elements from the deployed scenario
*ActiveScenarioApi* | [**GetActiveScenarioPhysicalLocation**](docs/ActiveScenarioApi.md#getactivescenariophysicallocation) | **Get** /active/physicalLocations | Get physical location elements from the deployed scenario
*ActiveScenarioApi* | [**GetActiveScenarioProcess**](docs/ActiveScenarioApi.md#getactivescenarioprocess) | **Get** /active/processes | Get process elements from the deployed scenario
*ActiveScenarioApi* | [**GetActiveScenarioZone**](docs/ActiveScenarioApi.md#getactivescenariozone) | **Get** /active/zones | Get zone elements from the deployed scenario
*ActiveScenarioApi* | [**TerminateScenario**](docs/ActiveScenarioApi.md#terminatescenario) | **Delete** /active | Terminate the deployed scenario
*ApplicationsApi* | [**ApplicationsAppInstanceIdDELETE**](docs/ApplicationsApi.md#applicationsappinstanceiddelete) | **Delete** /applications/{appInstanceId} | 
*ApplicationsApi* | [**ApplicationsAppInstanceIdGET**](docs/ApplicationsApi.md#applicationsappinstanceidget) | **Get** /applications/{appInstanceId} | 
*ApplicationsApi* | [**ApplicationsAppInstanceIdPUT**](docs/ApplicationsApi.md#applicationsappinstanceidput) | **Put** /applications/{appInstanceId} | 
*ApplicationsApi* | [**ApplicationsGET**](docs/ApplicationsApi.md#applicationsget) | **Get** /applications | 
*ApplicationsApi* | [**ApplicationsPOST**](docs/ApplicationsApi.md#applicationspost) | **Post** /applications | 
*ConnectivityApi* | [**CreatePduSession**](docs/ConnectivityApi.md#createpdusession) | **Post** /connectivity/pdu-session/{ueName}/{pduSessionId} | Create a PDU Session
*ConnectivityApi* | [**GetPduSessionList**](docs/ConnectivityApi.md#getpdusessionlist) | **Get** /connectivity/pdu-session | Get list of PDU Sessions
*ConnectivityApi* | [**TerminatePduSession**](docs/ConnectivityApi.md#terminatepdusession) | **Delete** /connectivity/pdu-session/{ueName}/{pduSessionId} | Terminate a PDU Session
*EventReplayApi* | [**CreateReplayFile**](docs/EventReplayApi.md#createreplayfile) | **Post** /replay/{name} | Add a replay file
*EventReplayApi* | [**CreateReplayFileFromScenarioExec**](docs/EventReplayApi.md#createreplayfilefromscenarioexec) | **Post** /replay/{name}/generate | Generate a replay file from Active Scenario events
*EventReplayApi* | [**DeleteReplayFile**](docs/EventReplayApi.md#deletereplayfile) | **Delete** /replay/{name} | Delete a replay file
*EventReplayApi* | [**DeleteReplayFileList**](docs/EventReplayApi.md#deletereplayfilelist) | **Delete** /replay | Delete all replay files
*EventReplayApi* | [**GetReplayFile**](docs/EventReplayApi.md#getreplayfile) | **Get** /replay/{name} | Get a specific replay file
*EventReplayApi* | [**GetReplayFileList**](docs/EventReplayApi.md#getreplayfilelist) | **Get** /replay | Get all replay file names
*EventReplayApi* | [**GetReplayStatus**](docs/EventReplayApi.md#getreplaystatus) | **Get** /replaystatus | Get status of replay manager
*EventReplayApi* | [**LoopReplay**](docs/EventReplayApi.md#loopreplay) | **Post** /replay/{name}/loop | Loop-Execute a replay file present in the platform store
*EventReplayApi* | [**PlayReplayFile**](docs/EventReplayApi.md#playreplayfile) | **Post** /replay/{name}/play | Execute a replay file present in the platform store
*EventReplayApi* | [**StopReplayFile**](docs/EventReplayApi.md#stopreplayfile) | **Post** /replay/{name}/stop | Stop execution of a replay file
*EventsApi* | [**SendEvent**](docs/EventsApi.md#sendevent) | **Post** /events/{type} | Send events to the deployed scenario
*ServicesApi* | [**ServicesGET**](docs/ServicesApi.md#servicesget) | **Get** /services | 


## Documentation For Models

 - [ActivationInfo](docs/ActivationInfo.md)
 - [ApplicationInfo](docs/ApplicationInfo.md)
 - [CellularDomainConfig](docs/CellularDomainConfig.md)
 - [CellularPoaConfig](docs/CellularPoaConfig.md)
 - [ConnectivityConfig](docs/ConnectivityConfig.md)
 - [CpuConfig](docs/CpuConfig.md)
 - [Deployment](docs/Deployment.md)
 - [DnConfig](docs/DnConfig.md)
 - [Domain](docs/Domain.md)
 - [Domains](docs/Domains.md)
 - [EgressService](docs/EgressService.md)
 - [Event](docs/Event.md)
 - [EventMobility](docs/EventMobility.md)
 - [EventNetworkCharacteristicsUpdate](docs/EventNetworkCharacteristicsUpdate.md)
 - [EventPduSession](docs/EventPduSession.md)
 - [EventPoasInRange](docs/EventPoasInRange.md)
 - [EventScenarioUpdate](docs/EventScenarioUpdate.md)
 - [ExternalConfig](docs/ExternalConfig.md)
 - [GeoData](docs/GeoData.md)
 - [GpuConfig](docs/GpuConfig.md)
 - [IngressService](docs/IngressService.md)
 - [LineString](docs/LineString.md)
 - [MemoryConfig](docs/MemoryConfig.md)
 - [NetworkCharacteristics](docs/NetworkCharacteristics.md)
 - [NetworkLocation](docs/NetworkLocation.md)
 - [NetworkLocations](docs/NetworkLocations.md)
 - [NodeDataUnion](docs/NodeDataUnion.md)
 - [NodeServiceMaps](docs/NodeServiceMaps.md)
 - [PduSession](docs/PduSession.md)
 - [PduSessionInfo](docs/PduSessionInfo.md)
 - [PduSessionList](docs/PduSessionList.md)
 - [PhysicalLocation](docs/PhysicalLocation.md)
 - [PhysicalLocations](docs/PhysicalLocations.md)
 - [Poa4GConfig](docs/Poa4GConfig.md)
 - [Poa5GConfig](docs/Poa5GConfig.md)
 - [PoaWifiConfig](docs/PoaWifiConfig.md)
 - [Point](docs/Point.md)
 - [Process](docs/Process.md)
 - [Processes](docs/Processes.md)
 - [Replay](docs/Replay.md)
 - [ReplayEvent](docs/ReplayEvent.md)
 - [ReplayFileList](docs/ReplayFileList.md)
 - [ReplayInfo](docs/ReplayInfo.md)
 - [ReplayStatus](docs/ReplayStatus.md)
 - [Scenario](docs/Scenario.md)
 - [ScenarioConfig](docs/ScenarioConfig.md)
 - [ScenarioNode](docs/ScenarioNode.md)
 - [ServiceConfig](docs/ServiceConfig.md)
 - [ServiceInfo](docs/ServiceInfo.md)
 - [ServicePort](docs/ServicePort.md)
 - [Zone](docs/Zone.md)
 - [Zones](docs/Zones.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

