/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Platform Controller REST API
 *
 * This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

// Physical location object
type PhysicalLocation struct {
	// Unique physical location ID
	Id string `json:"id,omitempty"`
	// Physical location name
	Name string `json:"name,omitempty"`
	// Physical location type
	Type_ string `json:"type,omitempty"`
	// true: Physical location is external to MEEP false: Physical location is internal to MEEP
	IsExternal              bool     `json:"isExternal,omitempty"`
	GeoData                 *GeoData `json:"geoData,omitempty"`
	NetworkLocationsInRange []string `json:"networkLocationsInRange,omitempty"`
	// true: Physical location has network connectivity false: Physical location has no network connectivity
	Connected bool `json:"connected,omitempty"`
	// true: Physical location uses a wireless connection false: Physical location uses a wired connection
	Wireless bool `json:"wireless,omitempty"`
	// Prioritized, comma-separated list of supported wireless connection types. Default priority if not specififed is 'wifi,5g,4g,other'. Wireless connection types: - 4g - 5g - wifi - other
	WirelessType string    `json:"wirelessType,omitempty"`
	DataNetwork  *DnConfig `json:"dataNetwork,omitempty"`
	// Key/Value Pair Map (string, string)
	Meta map[string]string `json:"meta,omitempty"`
	// Key/Value Pair Map (string, string)
	UserMeta  map[string]string       `json:"userMeta,omitempty"`
	Processes []Process               `json:"processes,omitempty"`
	NetChar   *NetworkCharacteristics `json:"netChar,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar latency
	LinkLatency int32 `json:"linkLatency,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar latencyVariation
	LinkLatencyVariation int32 `json:"linkLatencyVariation,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar throughputUl and throughputDl
	LinkThroughput int32 `json:"linkThroughput,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar packetLoss
	LinkPacketLoss float64 `json:"linkPacketLoss,omitempty"`
	// Physical location MAC Address
	MacId string `json:"macId,omitempty"`
}
