/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 *
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"net/http"
)

// ActivateScenario - Activate (deploy) scenario
func ActivateScenario(w http.ResponseWriter, r *http.Request) {
	ceActivateScenario(w, r)
}

// GetActiveNodeServiceMaps - Retrieve list of active external node service mappings
func GetActiveNodeServiceMaps(w http.ResponseWriter, r *http.Request) {
	ceGetActiveNodeServiceMaps(w, r)
}

// GetActiveScenario - Retrieve active (deployed) scenario
func GetActiveScenario(w http.ResponseWriter, r *http.Request) {
	ceGetActiveScenario(w, r)
}

// GetActiveScenarioDomain - Retrieve active (deployed) scenario domains
func GetActiveScenarioDomain(w http.ResponseWriter, r *http.Request) {
	ceGetActiveScenarioDomain(w, r)
}

// GetActiveScenarioNl - Retrieve active (deployed) scenario network locations
func GetActiveScenarioNetworkLocation(w http.ResponseWriter, r *http.Request) {
	ceGetActiveScenarioNetworkLocation(w, r)
}

// GetActiveScenarioPl - Retrieve active (deployed) scenario physical locations
func GetActiveScenarioPhysicalLocation(w http.ResponseWriter, r *http.Request) {
	ceGetActiveScenarioPhysicalLocation(w, r)
}

// GetActiveScenarioProc - Retrieve active (deployed) scenario processes
func GetActiveScenarioProcess(w http.ResponseWriter, r *http.Request) {
	ceGetActiveScenarioProcess(w, r)
}

// GetActiveScenarioZone - Retrieve active (deployed) scenario zones
func GetActiveScenarioZone(w http.ResponseWriter, r *http.Request) {
	ceGetActiveScenarioZone(w, r)
}

// TerminateScenario - Terminate active (deployed) scenario
func TerminateScenario(w http.ResponseWriter, r *http.Request) {
	ceTerminateScenario(w, r)
}
