/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Mobility Group Service REST API
 *
 * Mobility Group Service allows to form groups formed multiple edge application instances and share user states automatically withing the group <p>**Micro-service**<br>[meep-mg-manager](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-mg-manager) <p>**Type & Usage**<br>Edge Service used by edge applications to share user state between the  Mobility Group members <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"net/http"
)

func CreateMobilityGroup(w http.ResponseWriter, r *http.Request) {
	mgCreateMobilityGroup(w, r)
}

func CreateMobilityGroupApp(w http.ResponseWriter, r *http.Request) {
	mgCreateMobilityGroupApp(w, r)
}

func CreateMobilityGroupUe(w http.ResponseWriter, r *http.Request) {
	mgCreateMobilityGroupUe(w, r)
}

func DeleteMobilityGroup(w http.ResponseWriter, r *http.Request) {
	mgDeleteMobilityGroup(w, r)
}

func DeleteMobilityGroupApp(w http.ResponseWriter, r *http.Request) {
	mgDeleteMobilityGroupApp(w, r)
}

func GetMobilityGroup(w http.ResponseWriter, r *http.Request) {
	mgGetMobilityGroup(w, r)
}

func GetMobilityGroupApp(w http.ResponseWriter, r *http.Request) {
	mgGetMobilityGroupApp(w, r)
}

func GetMobilityGroupAppList(w http.ResponseWriter, r *http.Request) {
	mgGetMobilityGroupAppList(w, r)
}

func GetMobilityGroupList(w http.ResponseWriter, r *http.Request) {
	mgGetMobilityGroupList(w, r)
}

func SetMobilityGroup(w http.ResponseWriter, r *http.Request) {
	mgSetMobilityGroup(w, r)
}

func SetMobilityGroupApp(w http.ResponseWriter, r *http.Request) {
	mgSetMobilityGroupApp(w, r)
}
