/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/LinkType', 'model/SerName', 'model/ServiceState'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./LinkType'), require('./SerName'), require('./ServiceState'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.ServiceAvailabilityNotificationServiceReferences = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.LinkType, root.MecDemo3Api.SerName, root.MecDemo3Api.ServiceState);
  }
}(this, function(ApiClient, LinkType, SerName, ServiceState) {
  'use strict';

  /**
   * The ServiceAvailabilityNotificationServiceReferences model module.
   * @module model/ServiceAvailabilityNotificationServiceReferences
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>ServiceAvailabilityNotificationServiceReferences</code>.
   * List of links to services whose availability has changed.
   * @alias module:model/ServiceAvailabilityNotificationServiceReferences
   * @class
   * @param serName {module:model/SerName} 
   * @param state {module:model/ServiceState} 
   * @param changeType {module:model/ServiceAvailabilityNotificationServiceReferences.ChangeTypeEnum} Type of the change. Valid values:  ADDED: The service was newly added.   REMOVED: The service was removed.   STATE_CHANGED: Only the state of the service was changed.    ATTRIBUTES_CHANGED: At least one attribute of the service other than state was changed. The change may or may not include changing the state.
   */
  var exports = function(serName, state, changeType) {
    this.serName = serName;
    this.state = state;
    this.changeType = changeType;
  };

  /**
   * Constructs a <code>ServiceAvailabilityNotificationServiceReferences</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ServiceAvailabilityNotificationServiceReferences} obj Optional instance to populate.
   * @return {module:model/ServiceAvailabilityNotificationServiceReferences} The populated <code>ServiceAvailabilityNotificationServiceReferences</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('link'))
        obj.link = LinkType.constructFromObject(data['link']);
      if (data.hasOwnProperty('serName'))
        obj.serName = SerName.constructFromObject(data['serName']);
      if (data.hasOwnProperty('state'))
        obj.state = ServiceState.constructFromObject(data['state']);
      if (data.hasOwnProperty('changeType'))
        obj.changeType = ApiClient.convertToType(data['changeType'], 'String');
    }
    return obj;
  }

  /**
   * @member {module:model/LinkType} link
   */
  exports.prototype.link = undefined;

  /**
   * @member {module:model/SerName} serName
   */
  exports.prototype.serName = undefined;

  /**
   * @member {module:model/ServiceState} state
   */
  exports.prototype.state = undefined;

  /**
   * Type of the change. Valid values:  ADDED: The service was newly added.   REMOVED: The service was removed.   STATE_CHANGED: Only the state of the service was changed.    ATTRIBUTES_CHANGED: At least one attribute of the service other than state was changed. The change may or may not include changing the state.
   * @member {module:model/ServiceAvailabilityNotificationServiceReferences.ChangeTypeEnum} changeType
   */
  exports.prototype.changeType = undefined;


  /**
   * Allowed values for the <code>changeType</code> property.
   * @enum {String}
   * @readonly
   */
  exports.ChangeTypeEnum = {
    /**
     * value: "ADDED"
     * @const
     */
    ADDED: "ADDED",

    /**
     * value: "REMOVED"
     * @const
     */
    REMOVED: "REMOVED",

    /**
     * value: "STATE_CHANGED"
     * @const
     */
    STATE_CHANGED: "STATE_CHANGED",

    /**
     * value: "ATTRIBUTES_CHANGED"
     * @const
     */
    ATTRIBUTES_CHANGED: "ATTRIBUTES_CHANGED"
  };

  return exports;

}));
