/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ServiceAvailabilityNotificationServiceReferences', 'model/Subscription'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ServiceAvailabilityNotificationServiceReferences'), require('./Subscription'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.ServiceAvailabilityNotification = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.ServiceAvailabilityNotificationServiceReferences, root.MecDemo3Api.Subscription);
  }
}(this, function(ApiClient, ServiceAvailabilityNotificationServiceReferences, Subscription) {
  'use strict';

  /**
   * The ServiceAvailabilityNotification model module.
   * @module model/ServiceAvailabilityNotification
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>ServiceAvailabilityNotification</code>.
   * This type represents the service availability information.
   * @alias module:model/ServiceAvailabilityNotification
   * @class
   * @param notificationType {String} Shall be set to SerAvailabilityNotification
   * @param serviceReferences {Array.<module:model/ServiceAvailabilityNotificationServiceReferences>} 
   * @param links {module:model/Subscription} 
   */
  var exports = function(notificationType, serviceReferences, links) {
    this.notificationType = notificationType;
    this.serviceReferences = serviceReferences;
    this.links = links;
  };

  /**
   * Constructs a <code>ServiceAvailabilityNotification</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ServiceAvailabilityNotification} obj Optional instance to populate.
   * @return {module:model/ServiceAvailabilityNotification} The populated <code>ServiceAvailabilityNotification</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('notificationType'))
        obj.notificationType = ApiClient.convertToType(data['notificationType'], 'String');
      if (data.hasOwnProperty('serviceReferences'))
        obj.serviceReferences = ApiClient.convertToType(data['serviceReferences'], [ServiceAvailabilityNotificationServiceReferences]);
      if (data.hasOwnProperty('_links'))
        obj.links = Subscription.constructFromObject(data['_links']);
    }
    return obj;
  }

  /**
   * Shall be set to SerAvailabilityNotification
   * @member {String} notificationType
   */
  exports.prototype.notificationType = undefined;

  /**
   * @member {Array.<module:model/ServiceAvailabilityNotificationServiceReferences>} serviceReferences
   */
  exports.prototype.serviceReferences = undefined;

  /**
   * @member {module:model/Subscription} links
   */
  exports.prototype.links = undefined;

  return exports;

}));
