/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/AssociateId', 'model/MobilityProcedureNotificationTargetAppInfo', 'model/TimeStamp'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./AssociateId'), require('./MobilityProcedureNotificationTargetAppInfo'), require('./TimeStamp'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.MobilityProcedureNotification = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.AssociateId, root.MecDemo3Api.MobilityProcedureNotificationTargetAppInfo, root.MecDemo3Api.TimeStamp);
  }
}(this, function(ApiClient, AssociateId, MobilityProcedureNotificationTargetAppInfo, TimeStamp) {
  'use strict';

  /**
   * The MobilityProcedureNotification model module.
   * @module model/MobilityProcedureNotification
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>MobilityProcedureNotification</code>.
   * @alias module:model/MobilityProcedureNotification
   * @class
   * @param mobilityStatus {Number} Indicate the status of the UE mobility. Values are defined as following:      1 = INTERHOST_MOVEOUT_TRIGGERED.      2 = INTERHOST_MOVEOUT_COMPLETED.      3 = INTERHOST_MOVEOUT_FAILED.       Other values are reserved.
   * @param notificationType {String} Shall be set to \\\"MobilityProcedureNotification\\\".
   */
  var exports = function(mobilityStatus, notificationType) {
    this.mobilityStatus = mobilityStatus;
    this.notificationType = notificationType;
  };

  /**
   * Constructs a <code>MobilityProcedureNotification</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/MobilityProcedureNotification} obj Optional instance to populate.
   * @return {module:model/MobilityProcedureNotification} The populated <code>MobilityProcedureNotification</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('associateId'))
        obj.associateId = ApiClient.convertToType(data['associateId'], [AssociateId]);
      if (data.hasOwnProperty('mobilityStatus'))
        obj.mobilityStatus = ApiClient.convertToType(data['mobilityStatus'], 'Number');
      if (data.hasOwnProperty('notificationType'))
        obj.notificationType = ApiClient.convertToType(data['notificationType'], 'String');
      if (data.hasOwnProperty('targetAppInfo'))
        obj.targetAppInfo = MobilityProcedureNotificationTargetAppInfo.constructFromObject(data['targetAppInfo']);
      if (data.hasOwnProperty('timeStamp'))
        obj.timeStamp = TimeStamp.constructFromObject(data['timeStamp']);
    }
    return obj;
  }

  /**
   * 0 to N identifiers to associate the information for specific UE(s) and flow(s).
   * @member {Array.<module:model/AssociateId>} associateId
   */
  exports.prototype.associateId = undefined;

  /**
   * Indicate the status of the UE mobility. Values are defined as following:      1 = INTERHOST_MOVEOUT_TRIGGERED.      2 = INTERHOST_MOVEOUT_COMPLETED.      3 = INTERHOST_MOVEOUT_FAILED.       Other values are reserved.
   * @member {Number} mobilityStatus
   */
  exports.prototype.mobilityStatus = undefined;

  /**
   * Shall be set to \\\"MobilityProcedureNotification\\\".
   * @member {String} notificationType
   */
  exports.prototype.notificationType = undefined;

  /**
   * @member {module:model/MobilityProcedureNotificationTargetAppInfo} targetAppInfo
   */
  exports.prototype.targetAppInfo = undefined;

  /**
   * @member {module:model/TimeStamp} timeStamp
   */
  exports.prototype.timeStamp = undefined;

  return exports;

}));
