/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/AppTerminationSubscriptionLinks'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./AppTerminationSubscriptionLinks'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.AppTerminationSubscription = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.AppTerminationSubscriptionLinks);
  }
}(this, function(ApiClient, AppTerminationSubscriptionLinks) {
  'use strict';

  /**
   * The AppTerminationSubscription model module.
   * @module model/AppTerminationSubscription
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>AppTerminationSubscription</code>.
   * This type represents the information that the MEC platform notifies the subscribed application instance about  the corresponding application instance termination/stop.
   * @alias module:model/AppTerminationSubscription
   * @class
   * @param subscriptionType {String} Shall be set to AppTerminationSubscription.
   * @param callbackReference {String} URI selected by the MEC application instance to receive notifications on the subscribed MEC application instance management information. This shall be included in both the request and the response.
   * @param links {module:model/AppTerminationSubscriptionLinks} 
   * @param appInstanceId {String} It is used as the filtering criterion for the subscribed events.
   */
  var exports = function(subscriptionType, callbackReference, links, appInstanceId) {
    this.subscriptionType = subscriptionType;
    this.callbackReference = callbackReference;
    this.links = links;
    this.appInstanceId = appInstanceId;
  };

  /**
   * Constructs a <code>AppTerminationSubscription</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/AppTerminationSubscription} obj Optional instance to populate.
   * @return {module:model/AppTerminationSubscription} The populated <code>AppTerminationSubscription</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('subscriptionType'))
        obj.subscriptionType = ApiClient.convertToType(data['subscriptionType'], 'String');
      if (data.hasOwnProperty('callbackReference'))
        obj.callbackReference = ApiClient.convertToType(data['callbackReference'], 'String');
      if (data.hasOwnProperty('_links'))
        obj.links = AppTerminationSubscriptionLinks.constructFromObject(data['_links']);
      if (data.hasOwnProperty('appInstanceId'))
        obj.appInstanceId = ApiClient.convertToType(data['appInstanceId'], 'String');
    }
    return obj;
  }

  /**
   * Shall be set to AppTerminationSubscription.
   * @member {String} subscriptionType
   */
  exports.prototype.subscriptionType = undefined;

  /**
   * URI selected by the MEC application instance to receive notifications on the subscribed MEC application instance management information. This shall be included in both the request and the response.
   * @member {String} callbackReference
   */
  exports.prototype.callbackReference = undefined;

  /**
   * @member {module:model/AppTerminationSubscriptionLinks} links
   */
  exports.prototype.links = undefined;

  /**
   * It is used as the filtering criterion for the subscribed events.
   * @member {String} appInstanceId
   */
  exports.prototype.appInstanceId = undefined;

  return exports;

}));
