/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ApplicationInstance'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/ApplicationInstance'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.FrontendApi = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.ApplicationInstance);
  }
}(this, function(ApiClient, ApplicationInstance) {
  'use strict';

  /**
   * Frontend service.
   * @module api/FrontendApi
   * @version 0.0.1
   */

  /**
   * Constructs a new FrontendApi. 
   * @alias module:api/FrontendApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the deleteAmsDevice operation.
     * @callback module:api/FrontendApi~deleteAmsDeviceCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete an AMS device
     * Delete an AMS device
     * @param {String} device Delete device from AMS service resource
     * @param {module:api/FrontendApi~deleteAmsDeviceCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteAmsDevice = function(device, callback) {
      var postBody = null;

      // verify the required parameter 'device' is set
      if (device === undefined || device === null) {
        throw new Error("Missing the required parameter 'device' when calling deleteAmsDevice");
      }


      var pathParams = {
        'device': device
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/service/ams/delete/{device}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deregister operation.
     * @callback module:api/FrontendApi~deregisterCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deregister with MEC Platform and delete associated resources
     * Deregister with MEC Platform and delete associated resources
     * @param {module:api/FrontendApi~deregisterCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deregister = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/info/application/delete', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getActivityLogs operation.
     * @callback module:api/FrontendApi~getActivityLogsCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns activity logs
     * Returns activity logs
     * @param {module:api/FrontendApi~getActivityLogsCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.getActivityLogs = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/info/logs', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getAmsDevices operation.
     * @callback module:api/FrontendApi~getAmsDevicesCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns the list of AMS Devices
     * Returns the list of AMS Devices
     * @param {module:api/FrontendApi~getAmsDevicesCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.getAmsDevices = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/info/ams', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getPlatformInfo operation.
     * @callback module:api/FrontendApi~getPlatformInfoCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApplicationInstance} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns the application dynamic information
     * Returns the application dynamic information
     * @param {module:api/FrontendApi~getPlatformInfoCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ApplicationInstance}
     */
    this.getPlatformInfo = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/problem+json'];
      var returnType = ApplicationInstance;

      return this.apiClient.callApi(
        '/info/application', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the register operation.
     * @callback module:api/FrontendApi~registerCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApplicationInstance} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Register with MEC Platform and create necessary resources
     * Register with MEC Platform and create necessary resources
     * @param {module:api/FrontendApi~registerCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ApplicationInstance}
     */
    this.register = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/problem+json'];
      var returnType = ApplicationInstance;

      return this.apiClient.callApi(
        '/register/app', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateAmsDevices operation.
     * @callback module:api/FrontendApi~updateAmsDevicesCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates the list of AMS devices
     * Updates the list of AMS devices
     * @param {String} device Start AMS service resource to track device name
     * @param {module:api/FrontendApi~updateAmsDevicesCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.updateAmsDevices = function(device, callback) {
      var postBody = null;

      // verify the required parameter 'device' is set
      if (device === undefined || device === null) {
        throw new Error("Missing the required parameter 'device' when calling updateAmsDevices");
      }


      var pathParams = {
        'device': device
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/service/ams/update/{device}', 'PUT',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
