# meep_demo_app_api

MeepDemoAppApi - JavaScript client for meep_demo_app_api
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 0.0.1
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install meep_demo_app_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your meep_demo_app_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('meep_demo_app_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var MeepDemoAppApi = require('meep_demo_app_api');

var api = new MeepDemoAppApi.EdgeAppInfoApi()

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.getEdgeInfo(callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MeepDemoAppApi.EdgeAppInfoApi* | [**getEdgeInfo**](docs/EdgeAppInfoApi.md#getEdgeInfo) | **GET** /edge-app | Retrieve edge add info
*MeepDemoAppApi.NotificationsApi* | [**postTrackingNotification**](docs/NotificationsApi.md#postTrackingNotification) | **POST** /location_notifications/{subscriptionId} | This operation is used by the AdvantEDGE Location Service to issue a callback notification towards an ME application with a zonal or user tracking subscription
*MeepDemoAppApi.StateTransferApi* | [**handleEvent**](docs/StateTransferApi.md#handleEvent) | **POST** /mg/event | Send event notification to registered Mobility Group Application
*MeepDemoAppApi.UELocationApi* | [**getUeLocation**](docs/UELocationApi.md#getUeLocation) | **GET** /location/{ueId} | Retrieves the UE location values
*MeepDemoAppApi.UEStateApi* | [**createUeState**](docs/UEStateApi.md#createUeState) | **POST** /ue/{ueId} | Registers the UE and starts a counter
*MeepDemoAppApi.UEStateApi* | [**deleteUeState**](docs/UEStateApi.md#deleteUeState) | **DELETE** /ue/{ueId} | Deregistration of a UE
*MeepDemoAppApi.UEStateApi* | [**getUeState**](docs/UEStateApi.md#getUeState) | **GET** /ue/{ueId} | Retrieves the UE state values
*MeepDemoAppApi.UEStateApi* | [**updateUeState**](docs/UEStateApi.md#updateUeState) | **PUT** /ue/{ueId} | Updates the UE state values


## Documentation for Models

 - [MeepDemoAppApi.EdgeInfo](docs/EdgeInfo.md)
 - [MeepDemoAppApi.InlineTrackingNotification](docs/InlineTrackingNotification.md)
 - [MeepDemoAppApi.MobilityGroupAppState](docs/MobilityGroupAppState.md)
 - [MeepDemoAppApi.MobilityGroupEvent](docs/MobilityGroupEvent.md)
 - [MeepDemoAppApi.SubscriptionId](docs/SubscriptionId.md)
 - [MeepDemoAppApi.TimeStamp](docs/TimeStamp.md)
 - [MeepDemoAppApi.TrackingNotification](docs/TrackingNotification.md)
 - [MeepDemoAppApi.UeState](docs/UeState.md)
 - [MeepDemoAppApi.UserEventType](docs/UserEventType.md)
 - [MeepDemoAppApi.UserInfo](docs/UserInfo.md)
 - [MeepDemoAppApi.UserList](docs/UserList.md)
 - [MeepDemoAppApi.UserTrackingNotification](docs/UserTrackingNotification.md)
 - [MeepDemoAppApi.ZoneInfo](docs/ZoneInfo.md)


## Documentation for Authorization

 All endpoints do not require authorization.

