# Go API client for swagger

Multi-access Traffic Steering Sercice is AdvantEDGE's implementation of [ETSI MEC ISG MEC015 Traffic Management APIs](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/015/02.02.01_60/gs_MEC015v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-tm](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-tm/server/mts) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about MTS Info and Session(s) in the network <p>**Note**<br>AdvantEDGE supports all Multi-access Traffic Steering API endpoints.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/mts/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MtsApi* | [**Mec011AppTerminationPOST**](docs/MtsApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*MtsApi* | [**MtsCapabilityInfoGET**](docs/MtsApi.md#mtscapabilityinfoget) | **Get** /mts_capability_info | Retrieve the MTS capability informations
*MtsApi* | [**MtsSessionDELETE**](docs/MtsApi.md#mtssessiondelete) | **Delete** /mts_sessions/{sessionId} | Remove specific MTS session
*MtsApi* | [**MtsSessionGET**](docs/MtsApi.md#mtssessionget) | **Get** /mts_sessions/{sessionId} | Retrieve information about specific MTS session
*MtsApi* | [**MtsSessionPOST**](docs/MtsApi.md#mtssessionpost) | **Post** /mts_sessions | Create a MTS session
*MtsApi* | [**MtsSessionPUT**](docs/MtsApi.md#mtssessionput) | **Put** /mts_sessions/{sessionId} | Update the information about specific MTS session
*MtsApi* | [**MtsSessionsListGET**](docs/MtsApi.md#mtssessionslistget) | **Get** /mts_sessions | Retrieve information about a list of MTS sessions

## Documentation For Models

 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [LinkType](docs/LinkType.md)
 - [MtsCapabilityInfo](docs/MtsCapabilityInfo.md)
 - [MtsCapabilityInfoMtsAccessInfo](docs/MtsCapabilityInfoMtsAccessInfo.md)
 - [MtsCapabilityInfoTimeStamp](docs/MtsCapabilityInfoTimeStamp.md)
 - [MtsSessionInfo](docs/MtsSessionInfo.md)
 - [MtsSessionInfoFlowFilter](docs/MtsSessionInfoFlowFilter.md)
 - [MtsSessionInfoQosD](docs/MtsSessionInfoQosD.md)
 - [MtsSessionInfoTimeStamp](docs/MtsSessionInfoTimeStamp.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [ProblemDetails](docs/ProblemDetails.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com
