/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE WLAN Access Information API
 *
 * WLAN Access Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC028 WAI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/028/02.03.01_60/gs_MEC028v020301p.pdf) <p>[Copyright (c) ETSI 2020](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-wais](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-wais) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about WLAN access information in the network <p>**Note**<br>AdvantEDGE supports a selected subset of WAI API subscription types. <p>Supported subscriptions: <p> - AssocStaSubscription <p> - StaDataRateSubscription
 *
 * API version: 2.3.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

type MeasurementReportSubscription struct {
	Links *AssocStaSubscriptionLinks `json:"_links,omitempty"`
	// URI exposed by the client on which to receive notifications via HTTP. At least one of callbackReference and websockNotifConfig shall be provided by the service consumer. If both are provided, it is up to WAIS to select an alternative and return only that alternative in the response, as specified in ETSI GS MEC 009, clause 6.12a.
	CallbackReference string     `json:"callbackReference,omitempty"`
	ExpiryDeadline    *TimeStamp `json:"expiryDeadline,omitempty"`
	// Unique identifier allocated by the service consumer to identify measurement reports associated with this measurement subscription.
	MeasurementId   string           `json:"measurementId"`
	MeasurementInfo *MeasurementInfo `json:"measurementInfo"`
	// Set to TRUE by the service consumer to request a test notification via HTTP on the callbackReference URI, as specified in ETSI GS MEC 009, clause 6.12a.
	RequestTestNotification bool `json:"requestTestNotification,omitempty"`
	// Identifier(s) to uniquely specify the target client station(s) for the subscription.
	StaId []StaIdentity `json:"staId"`
	// Shall be set to \"MeasurementReportSubscription\".
	SubscriptionType   string              `json:"subscriptionType"`
	WebsockNotifConfig *WebsockNotifConfig `json:"websockNotifConfig,omitempty"`
}
